package com.elitesland.tw.tw5.api.prd.pms.service;




import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectCalendarPayload;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectCalendarVO;

import java.util.List;

/**
 * 项目工作日历
 * @date 2023-06-21
 */
public interface PmsProjectCalendarService {


    /**
     *  查询 某节点  某段时间的工作日历
     * @param payload
     * @return
     */
    PmsProjectCalendarVO findBySource(PmsProjectCalendarPayload payload);

    /***
     * 日历缓存 生成或清除
     * @param sourceIds
     * @param sourceType
     * @param handleType  save保存 clean清除
     */
    void handleCalendarCache(List<Long> sourceIds , String sourceType ,String handleType,Long projectId);

    /**
     *新增工作日历
     */
    void  saveData(PmsProjectCalendarPayload payload);

    /**
     * 批量更新工作日历
     * @param list
     */
     void batchSave(List<PmsProjectCalendarPayload> list);

    /**
     * 根据主键  逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 根据关联主键  逻辑删除
     * @param sourceIds  关联主键集合
     * @param sourceType 关联类型
     */
    void deleteSoftBySource(List<Long> sourceIds,String sourceType);

}
