package com.elitesland.tw.tw5.api.prd.pms.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectSummaryPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectSummaryQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectSummaryVO;

import java.util.List;

/**
 * 项目会议纪要
 *
 * @author zoey
 * @date 2024-05-28
 */
public interface PmsProjectSummaryService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsProjectSummaryVO}>
     */
    PagingVO<PmsProjectSummaryVO> queryPaging(PmsProjectSummaryQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsProjectSummaryVO}>
     */
    List<PmsProjectSummaryVO> queryListDynamic(PmsProjectSummaryQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PmsProjectSummaryVO}
     */
    PmsProjectSummaryVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PmsProjectSummaryVO}
     */
    PmsProjectSummaryVO insert(PmsProjectSummaryPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PmsProjectSummaryVO}
     */
    PmsProjectSummaryVO update(PmsProjectSummaryPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(PmsProjectSummaryPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 带权限的分页
     *
     * @param query
     * @return
     */
    PagingVO<PmsProjectSummaryVO> pagingPermission(PmsProjectSummaryQuery query);

    /**
     * 带权限列表
     *
     * @param query
     * @return
     */
    List<PmsProjectSummaryVO> listPermissionDynamic(PmsProjectSummaryQuery query);
}
