package com.elitesland.tw.tw5.api.prd.pms.service;

import com.elitesland.tw.tw5.api.common.log.vo.ComLogVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.*;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsLogQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsSnapshotQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsSnapshotVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsVO;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.List;

/**
 * 项目wbs表
 *
 * @author carl
 * @date 2023-04-06
 */
public interface PmsProjectWbsService {

    /**
     * 批量新增或修改
     *
     * @param payload 单据数据
     * @return {@link PmsProjectWbsVO}
     */
    PmsProjectWbsVO batchInsertOrUpdate(PmsProjectWbsDataPayload payload);


    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsProjectWbsVO}>
     */
    List<PmsProjectWbsVO> queryList(PmsProjectWbsQuery query);

    List<PmsProjectWbsVO> queryListSimple(PmsProjectWbsQuery query);

    /**
     * 根据主键查询
     *
     * @param keys 主键集合
     * @return {@link List}<{@link PmsProjectWbsVO}>
     */
    List<PmsProjectWbsVO> queryListByIds(List<Long> keys);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PmsProjectWbsVO}
     */
    PmsProjectWbsVO queryByKey(Long key);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 查日志列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link ComLogVO}>
     */
    List<ComLogVO> queryLogList(PmsProjectWbsLogQuery query);


    /**
     * 新增基线快照
     *
     * @param payload 单据数据
     * @return {@link}
     */
    PmsProjectWbsSnapshotVO insertSnapshot(PmsProjectWbsSnapshotPayload payload);

    /**
     * 查询基线快照列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsProjectWbsSnapshotVO}>
     */
    List<PmsProjectWbsSnapshotVO> querySnapshotList(PmsProjectWbsSnapshotQuery query);

    /**
     * 逻辑删除基线快照
     *
     * @param snapshotKeys 主键集合
     */
    void deleteSoftSnapshot(List<Long> snapshotKeys);


    /**
     * 查询相关方所在节点数据列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsProjectWbsVO}>
     */
    List<PmsProjectWbsVO> queryStakeholdersList(PmsProjectWbsQuery query);

    /**
     * 删除项目下节点负责人
     *
     * @param projectId
     * @param managerUserIds
     */
    void deleteManagerUserIds(Long projectId, List<Long> managerUserIds);

    /**
     * 更改活动节点 进度
     *
     * @param wbsId
     * @param wbsProgress
     */
    void updateWbsProgress(Long wbsId, BigDecimal wbsProgress, String wbsStatus);


    /**
     * 获取项目进度
     *
     * @param projectId
     */
    BigDecimal getProjectProgress(Long projectId);

    /**
     * 自动排期
     *
     * @param payload
     */
    void autoScheduling(PmsProjectWbsSchedulingPayload payload);

    /**
     * 修改排期状态
     *
     * @param projectId
     */
    void updateSchedulingStatus(Long projectId);

    /**
     * 项目里程碑
     *
     * @param query 查询
     * @return {@link List}<{@link PmsProjectWbsVO}>
     */
    List<PmsProjectWbsVO> listMilestone(PmsProjectWbsQuery query);

    /**
     * 阶段列表
     *
     * @param query 查询
     * @return {@link List}<{@link PmsProjectWbsVO}>
     */
    List<PmsProjectWbsVO> listStage(PmsProjectWbsQuery query);

    /**
     * 通过活动的预计开始结束时间赋值阶段预计开始结束日期
     *
     * @param pmsProjectWbsVOS   wbsvos
     * @param calculateCostsFlag 是否计算成本
     */
    void setActgPreDateByAct(List<PmsProjectWbsVO> pmsProjectWbsVOS, boolean calculateCostsFlag);

    /**
     * 对wbs变更进行提交
     *
     * @param wbsId
     * @return
     */
//    Boolean submit(List<Long> wbsId);


    List<PmsProjectWbsVO> submitVer(List<Long> wbsId);


    /**
     * 生成下一版本号数据
     *
     * @param pmsProjectWbsVOS
     */
    void createNextVersion(List<PmsProjectWbsVO> pmsProjectWbsVOS);

    List<PmsProjectWbsVO> submitVerPro(PmsProjectWbsSubmitDataPayload payload);

    void savePro(PmsProjectWbsSubmitDataPayload payload);

    /**
     * 修改状态
     *
     * @param payload
     * @return
     */
    Long updateState(PmsProjectWbsPayload payload);


    void updateAllocateInfo(Long activityId, BigDecimal allocateEqva, BigDecimal allocateCost, String allocateStatus);

    void updateAllocateStatus(List<Long> wbsIdList, String status);

    void batchUpdate(List<PmsProjectWbsPayload> activityPayloads);

    void updateAllocateStatusByEffId(List<Long> activityIds, String actStatus);

    void updateAllocateInfoByEffId(Long activityId, BigDecimal allocateEqva, BigDecimal allocateCost, String allocateStatus);

    /**
     * 检查wbs数据必填项
     *
     * @param query
     */
    void checkStep2(PmsProjectWbsQuery query);

    /**
     * wbs数据导出
     *
     * @param response
     * @param query
     */
    void exportElecPlanTask(HttpServletResponse response, PmsProjectWbsQuery query);

    /**
     * 文件导入
     *
     * @param file
     */
    List<PmsProjectWbsVO> importElecPlanTask(MultipartFile file, Long projectId);
}
