package com.elitesland.tw.tw5.api.prd.pms.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsSnapshotPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsSnapshotQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsSnapshotVO;


import java.util.List;

/**
 * 项目wbs快照
 *
 * @author carl
 * @date 2023-04-17
 */
public interface PmsProjectWbsSnapshotService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsProjectWbsSnapshotVO}>
     */
    PagingVO<PmsProjectWbsSnapshotVO> queryPaging(PmsProjectWbsSnapshotQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsProjectWbsSnapshotVO}>
     */
    List<PmsProjectWbsSnapshotVO> queryListDynamic(PmsProjectWbsSnapshotQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PmsProjectWbsSnapshotVO}
     */
    PmsProjectWbsSnapshotVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PmsProjectWbsSnapshotVO}
     */
    PmsProjectWbsSnapshotVO insert(PmsProjectWbsSnapshotPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PmsProjectWbsSnapshotVO}
     */
    PmsProjectWbsSnapshotVO update(PmsProjectWbsSnapshotPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
