package com.elitesland.tw.tw5.api.prd.pms.vo;

import com.elitesland.tw.tw5.api.common.TwCommonVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;


/**
 * @author : WWW
 * @date : 2024-2-26
 * @desc : 项目wbs资源分配
 */
@Data
@ApiModel(description = "项目wbs资源分配")
public class PmsProjectWbsResourceVO extends TwCommonVO implements Serializable {


    /**
     * wbs主键
     */
    @ApiModelProperty("wbs主键")
    private Long wbsId;

    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Long projectId;

    /**
     * 相关方id
     */
    @ApiModelProperty("相关方id")
    private Long relatePartiesId;
    private String relatePartiesName;

    /**
     * 角色id
     */
    @ApiModelProperty("角色id")
    private Long roleId;
    private String roleName;

    /**
     * 负责人标识
     */
    @ApiModelProperty("负责人标识")
    private Boolean managerUserFlag;

    /**
     * 投入精力
     */
    @ApiModelProperty("投入精力")
    private BigDecimal input;


    /**
     * 版本id
     */
    @ApiModelProperty("版本id")
    private Long versionId;

    /**
     * 版本号
     */
    @ApiModelProperty("版本号")
    private Integer versionNo;


    @ApiModelProperty("有效关联id")
    private Long effRelateId;


    /**
     * wbs编码
     */
    @ApiModelProperty("wbs编码")
    private String wbsCode;


    /**
     * 参考当量
     */
    @ApiModelProperty("参考当量")
    private BigDecimal referenceEqvaRatio;
}

