package com.elitesland.tw.tw5.api.prd.salecon.payload;

import com.alibaba.excel.annotation.ExcelProperty;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 采购需求处理明细
 *
 * @author likunpeng
 * @date 2023-03-29
 */
@Getter
@Setter
public class ConPurchaseDemandDPayload extends TwCommonPayload implements Serializable {
    /**
     * 需求日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("需求日期")
    private LocalDate demandDate;
    /**
     * 需求负责人
     */
    @ApiModelProperty("需求负责人")
    private Long demandDirectorUserId;
    /**
     * 建议供应商ID
     */
    @ApiModelProperty("建议供应商ID")
    private Long supplierId;
    /**
     * 需求说明
     */
    @ApiModelProperty("需求说明")
    private String demandSaid;
    /**
     * 关联产品
     */
    @ApiModelProperty("关联产品")
    private Long productId;
    /**
     * 采购大类ID
     */
    @ApiModelProperty("采购大类ID")
    private Long productClassId;
    /**
     * 采购小类ID
     */
    @ApiModelProperty("采购小类ID")
    private Long productSubClassId;

    /**
     * 采购大类名称
     */
    @ApiModelProperty("采购大类")
    private String productClass;
    /**
     * 采购小类名称
     */
    @ApiModelProperty("采购小类")
    private String productSubClass;

    /**
     * 数量
     */
    @ApiModelProperty("数量")
    private Integer demandNum;
    /**
     * 含税单价
     */
    @ApiModelProperty("含税单价")
    private BigDecimal taxPrice;
    /**
     * 货币
     */
    @ApiModelProperty("货币")
    private String symbol;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    /**
     * 含税总额
     */
    @ApiModelProperty("含税总额")
    private BigDecimal taxAmt;
    /**
     * 不含税总额
     */
    @ApiModelProperty("不含税总额")
    private BigDecimal notTaxAmt;
    /**
     * 采购合同id
     */
    @ApiModelProperty("采购合同id")
    private Long purContractId;
    /**
     * 采购需求id
     */
    @ApiModelProperty("采购需求id")
    private Long purDemandId;
    /**
     * 需求状态
     */
    @ApiModelProperty("需求状态")
    private String demandStatus;
    private Long demandDetailIdV4;

    /**
     * 销售合同id
     */
    @ApiModelProperty("销售合同id")
    private Long saleConId;

    /**
     * 需求编号
     */
    @ApiModelProperty("需求编号")
    @ExcelProperty(index = 0,value = "需求编号")
    private String demandCode;
    /**
     * 需求类别
     */
    @ApiModelProperty("需求类别")
    private String demandType;
}
