package com.elitesland.tw.tw5.api.prd.task.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskInfoPayload;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskPayload;
import com.elitesland.tw.tw5.api.prd.task.query.TaskInfoQuery;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskProBoardVO;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.List;

/**
 * 任务
 *
 * @author xxb
 * @date 2023-11-17
 */
public interface TaskInfoService {
    /**
     * 获取有效任务状态
     *
     * @return
     */
    List<String> getEffectiveTaskStatus();

    /**
     * 单个任务详情修改
     *
     * @param taskInfoPayload
     */
    void updateTask(TaskInfoPayload taskInfoPayload);


    /**
     * 批量添加任务
     *
     * @param taskPayload
     */
    void batchAddTask(TaskPayload taskPayload);

    /**
     * 主键查询
     *
     * @param taskId
     * @return
     */
    TaskInfoVO queryByKey(Long taskId, Boolean needTaskPackage);

    /**
     * 任务编号查询
     *
     * @param taskNo
     * @return
     */
    TaskInfoVO queryByTaskNo(String taskNo);

    /**
     * 列表查询
     *
     * @param taskInfoQuery
     * @return
     */
    List<TaskInfoVO> queryList(TaskInfoQuery taskInfoQuery);

    /**
     * 查询列表公用
     *
     * @param taskInfoQuery 任务信息查询
     * @return {@link List}<{@link TaskInfoVO}>
     */
    List<TaskInfoVO> queryListCommon(TaskInfoQuery taskInfoQuery);

    /**
     * 分页查询
     *
     * @param taskInfoQuery
     * @return
     */
    PagingVO<TaskInfoVO> queryPage(TaskInfoQuery taskInfoQuery);


    /**
     * 批量保存任务
     *
     * @param taskInfoPayloads
     * @return
     */
    List<TaskInfoVO> batchSave(List<TaskInfoPayload> taskInfoPayloads);

    /**
     * 任务分解：对于派发给自己的任务，可对该任务进行拆分，分配给该项目中有任务包的其他成员
     *
     * @param taskPayload
     */
    void taskDecompose(TaskPayload taskPayload);

    /**
     * 当量调整--变更
     *
     * @param payload
     */
    void saveChangeLog(TaskInfoPayload payload);


    /**
     * 删除
     *
     * @param keys
     */
    void deleteSoft(List<Long> keys, Boolean... isCheck);

    /**
     * 任务申请
     *
     * @param taskPayload
     */
    void taskApply(TaskPayload taskPayload);

    /**
     * 处理任务完工申请
     *
     * @param key             任务id
     * @param operationStatus 0:拒绝，1：同意
     */

    void operationTaskFinish(Long key, String operationStatus);


    /**
     * 任务完工申请
     *
     * @param keys
     */
    void taskFinish(List<Long> keys);

    /**
     * 任务关闭
     *
     * @param keys
     */
    void taskClose(List<Long> keys);


    /**
     * 查询 属于自己的 任务验收 个数
     *
     * @return
     */
    long findAcceptCount(Long userId);

    /**
     * 流程回调
     *
     * @param payload
     */
    void processStatusChange(ProcessStatusChangePayload payload);

    /**
     * 流程变更回调
     *
     * @param payload
     */
    void processChangeStatusChange(ProcessStatusChangePayload payload);

    /**
     * 动态更新
     *
     * @param payload
     * @return
     */
    long updateByKeyDynamic(TaskInfoPayload payload);

    /**
     * 更新任务进度
     *
     * @param key
     * @param progress
     */
    void updateTaskProgress(Long key, BigDecimal progress);

//    /**
//     * 工时发起审批 、审批通过时，请求此接口
//     *
//     * @param key
//     * @param eqva   传整或 负数
//     * @param status
//     */
//    void updateTaskFromWorkHours(Long key, BigDecimal eqva, String status);

    /**
     * 更新已结算当量
     *
     * @param key
     * @param eqva
     */
    void updateSettledEqva(Long key, BigDecimal eqva);


    /**
     * 拉取可以结算的任务列表
     *
     * @param taskInfoQuery 任务状态
     * @return
     */
    List<TaskInfoVO> queryTaskSettleList(TaskInfoQuery taskInfoQuery);


    /**
     * 任务派发 :只有新建状态的任务可以派发
     *
     * @param keys
     */
    void taskAssign(List<Long> keys);

    /**
     * 自动创建任务（暂时奖励假用）
     * 奖励假sourceType来源:TaskSourceTypeEnum.REWARD.getCode()
     *
     * @param taskPayload
     */
    void taskAutoCreate(TaskPayload taskPayload);

    /**
     * 简单任务查询
     *
     * @param taskInfoQuery 任务状态
     * @return
     */
    List<TaskInfoVO> queryTaskSimpleList(TaskInfoQuery taskInfoQuery);

    /**
     * 任务导出配置
     * @param response
     * @param query
     */
    void batchExport(HttpServletResponse response, TaskInfoQuery query) throws IOException;

    /**
     * 根据任务来源进行操作（例如奖励假结算）
     * 奖励假sourceType来源:TaskSourceTypeEnum.REWARD.getCode()
     *
     * @param sourceType     任务来源类型：奖励假
     * @param sourceId       任务来源id：奖励假申请id
     * @param procInstStatus 审批状态
     */
    void taskOpertionBySource(String sourceType, Long sourceId, ProcInstStatus procInstStatus);

    /**
     * 根据场景id查询任务数量
     * @param x
     * @return
     */
    Long countBySceneId(Long x);

    /**
     * 根据流程id查询任务数量
     * @param ids
     * @return
     */
    Long countByFlowId(List<Long> ids);

    /**
     * 任务看板
     * @param taskInfoQuery
     * @return
     */
    List<TaskProBoardVO> boardView(TaskInfoQuery taskInfoQuery);
}
