package com.elitesland.tw.tw5.api.prd.task.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 任务
 *
 * @author xxb
 * @date 2023-11-16
 */
@Getter
@Setter
@ToString
public class TaskInfoVO extends BaseViewModel implements Serializable {

    @ApiModelProperty("事由id")
    private Long reasonId;
    @ApiModelProperty("事由名称")
    private String reasonName;
    @ApiModelProperty("事由类型 01 项目 02 售前 03 bu")
    private String reasonType;
    @UdcName(udcName = "PMS:PROJECT:TYPE", codePropName = "reasonType")
    private String reasonTypeDesc;
    @ApiModelProperty("任务包ID")
    private Long taskPackageId;
    @ApiModelProperty("任务包名称")
    private String taskPackageName;
    @ApiModelProperty("上级任务ID")
    private Long taskParentId;
    @ApiModelProperty("任务名称")
    private String taskName;
    @ApiModelProperty("任务编号")
    private String taskNo;

    @ApiModelProperty("任务负责人")
    private Long taskResId;
    @UdcName(udcName = "USER", codePropName = "taskResId")
    @ApiModelProperty("任务负责人")
    private String taskRes;

    @ApiModelProperty("任务派发资源id")
    private Long disterResId;

    @UdcName(udcName = "USER", codePropName = "disterResId")
    @ApiModelProperty("任务派发资源")
    private String disterResName;

    @ApiModelProperty("协助人")
    private Long assId;
    @UdcName(udcName = "USER", codePropName = "assId")
    @ApiModelProperty("协助人")
    private String ass;

    @ApiModelProperty("关联活动")
    private Long relatedActId;
    @ApiModelProperty("关联活动")
    private String relatedAct;

    @ApiModelProperty("计划开始日期")
    private LocalDate planStartDate;
    @ApiModelProperty("计划结束日期")
    private LocalDate planEndDate;

    @ApiModelProperty("任务类型")
    private String taskType;
    @UdcName(udcName = "work:assignment:assignment_type", codePropName = "taskType")
    private String taskTypeDesc;
    @ApiModelProperty("任务来源类型null或1是普通任务，2奖励假任务,3帮我吧工时创建")
    private String sourceType;
    @ApiModelProperty("来源id（如果是奖励假申请则是奖励假申请id）")
    private Long sourceId;
    @ApiModelProperty("任务描述")
    private String taskDes;
    @ApiModelProperty("任务验收标准")
    private String accepCriteria;
    @ApiModelProperty("优先级")
    private Integer priority;
    @ApiModelProperty("任务总当量数")
    private BigDecimal totalEqva;
    @ApiModelProperty("已结算当量数")
    private BigDecimal settledEqva;
    @ApiModelProperty("原始当量数")
    private BigDecimal originalEqva;
    @ApiModelProperty("计划当量数")
    private BigDecimal planEqva;
    @ApiModelProperty("追加当量数")
    private BigDecimal additionEqva;
    @ApiModelProperty("拆分当量数")
    private BigDecimal splitEqva;
    @ApiModelProperty("已使用当量（已填工时当量）")
    private BigDecimal usedEqva;
    @ApiModelProperty("有效当量数")
    private BigDecimal validEqva;

    @ApiModelProperty("释放当量数")
    private BigDecimal releaseEqva;

    @ApiModelProperty("工时已审批通过当量")
    private BigDecimal approvedEqva;

    @ApiModelProperty("是否评价:1已经评价过 0没有")
    private Integer evaluationflag;
    @ApiModelProperty("任务进度")
    private BigDecimal taskProgress;
    @ApiModelProperty("任务状态")
    private String taskStatus;
    @UdcName(udcName = "PMS:TASK:STATUS", codePropName = "taskStatus")
    private String taskStatusDesc;

    @ApiModelProperty("是否逾期")
    private String overdue;
    @ApiModelProperty("逾期天数")
    private long overdueDays;

    @ApiModelProperty("上级任务名称")
    private String taskParentName;

    @ApiModelProperty("任务申请标记")
    private Integer taskApplyFlag;

    @ApiModelProperty("任务申请流程Id")
    private String taskApplyProcessId;


    //-----任务包中信息 ---start---
    @ApiModelProperty("发任务包资源id")
    private Long disterPackegeResId;

    @ApiModelProperty("验收人")
    private Long acceptorId;

    // @ApiModelProperty("验收方式")
    // private String acceptMethod;

    //-----任务包中信息 ---end---


    @ApiModelProperty("实际开始日期")
    private LocalDate actualStartDate;
    @ApiModelProperty("实际结束日期")
    private LocalDate actualEndDate;

    @ApiModelProperty(value = "计价方式")
    private String pricingMethod;
    @ApiModelProperty("当量系数")
    private BigDecimal eqvaRatio;
    /**
     * 工时填报剩余可用当量
     */
    @ApiModelProperty("工时填报剩余可用当量")
    private BigDecimal effectiveEqva;
    /**
     * 当量结算单价
     */
    @ApiModelProperty(value = "当量结算单价")
    private BigDecimal settlePrice;

    /**
     * 当量收入单价
     */
    @ApiModelProperty(value = "当量收入单价")
    private BigDecimal incomePrice;

    /**
     * 来源帮我吧标记 1：是
     */
    @ApiModelProperty(value = "来源帮我吧标记 1：是")
    private Integer bw8Flag;

    /**
     * 占用当量
     */
    private BigDecimal occupyEqva = BigDecimal.ZERO;
    /**
     * 任务包状态
     */
    @ApiModelProperty(value = "任务包状态")
    private String taskPackageStatus;


    /**
     * 状态流id
     */
    @ApiModelProperty("状态流id")
    private Long stateFlowId;
    private String stateFlowName;

    /**
     * 参考任务进度
     */
    @ApiModelProperty("参考任务进度")
    private BigDecimal referenceTaskProgress;


    @ApiModelProperty("状态流编码")
    private String stateFlowCode;


    @ApiModelProperty("状态流版本")
    private Integer stateFlowVersionNo;

}
