package com.elitesland.tw.tw5.api.prd.acc.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 报销额度配置
 *
 * @author zoey
 * @date 2024-05-14
 */
@Getter
@Setter
public class AccReimSettingLimitRuleQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 专业级别 精确 */
    @ApiModelProperty("专业级别")
    private String professionalGrade;
    /** 管理级别 精确 */
    @ApiModelProperty("管理级别")
    private String manageGrade;
    /** 特大城市额度 精确 */
    @ApiModelProperty("特大城市额度")
    private BigDecimal megacitiesLimit;
    /** 一线城市额度 精确 */
    @ApiModelProperty("一线城市额度")
    private BigDecimal firstTierCityLimit;
    /** 其它城市额度 精确 */
    @ApiModelProperty("其它城市额度")
    private BigDecimal otherLimit;

    /** 报销逾期规则配置主表id 精确 */
    @ApiModelProperty("报销逾期规则配置主表id")
    private Long reimSettingLimitId;
}
