package com.elitesland.tw.tw5.api.prd.humanresources.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;

@Data
public class WorkOrderApplyPayload extends TwCommonPayload {

    @ApiModelProperty("派工单名称")
    private String applyName;

    @ApiModelProperty("事由类型")
    private String reasonType;

    @ApiModelProperty("事由号")
    private Long reasonId;

    @ApiModelProperty("事由")
    private String reasonName;

    @ApiModelProperty("顾问姓名")
    private String consultantName;

    @ApiModelProperty("复合能力")
    private Long capasetLevelId;

    @ApiModelProperty("复合能力")
    private String capasetLevelName;

    @ApiModelProperty("预计入场日期")
    private LocalDate expectedStartDate;

    @ApiModelProperty("预计结束日期")
    private LocalDate expectedEndDate;

    @ApiModelProperty("结算类型（人天/任务/月）")
    private String settleType;
    @ApiModelProperty("服务费(元/人天,月)")
    private String serviceFee;

    @ApiModelProperty("是否含税")
    private Boolean isTax;

    @ApiModelProperty("资源引入情况说明")
    private String situationDescribe;

    @ApiModelProperty("独立顾问个人信息")
    private String personalInfo;

    @ApiModelProperty("被推荐人简历")
    private String resumeCodes;

    @ApiModelProperty("派工单上传")
    private String orderCodes;

    @ApiModelProperty("派工单编号")
    private String applyNo;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;
}
