package com.elitesland.tw.tw5.api.prd.my.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDate;

@Data
public class UserVacationPayload extends TwCommonPayload {

    @ApiModelProperty("userId")
    @NotNull
    private Long userId;

    @ApiModelProperty("年度")
    private Long vacationYear;

    @ApiModelProperty("假期类型")
    private String vacationType;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("开始日期")
    private LocalDate startDate;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("结束日期")
    private LocalDate endDate;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("有效期")
    private LocalDate expirationDate;

    @ApiModelProperty("总天数")
    private BigDecimal totalDays;

    @ApiModelProperty("已用天数")
    private BigDecimal usedDays;


    @ApiModelProperty("工号(导入的时候通过工号查询id)")
    private String employeeNo;

    @ApiModelProperty("事由类型")
    private String reasonType;

    @ApiModelProperty("事由id")
    private Long reasonId;
}
