package com.elitesland.tw.tw5.api.prd.personplan.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.ExternalRelatedPartiesPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.ExternalRelatedPartiesQuery;
import com.elitesland.tw.tw5.api.prd.personplan.vo.ExternalRelatedPartiesVO;

import java.util.List;


/**
  * @author : WWW
  * @date : 2024-1-29
  * @desc : 外部相关方Service
  */
public interface ExternalRelatedPartiesService {
    
    /**
     * 新增外部相关方数据
     * @param externalRelatedPartiesPayload
     * @return
     */
    ExternalRelatedPartiesVO save(ExternalRelatedPartiesPayload externalRelatedPartiesPayload);
    
    /**
     * 根据主键更新
     * @param externalRelatedPartiesPayload
     * @return
     */
    ExternalRelatedPartiesVO updateAll(ExternalRelatedPartiesPayload externalRelatedPartiesPayload);
    
    /**
     * 根据主键获取详情
     * @param id
     * @return
     */
    ExternalRelatedPartiesVO get(Long id);
    
    /**
     * 分页查询列表
     * @param externalRelatedPartiesQuery
     * @return
     */
    PagingVO<ExternalRelatedPartiesVO> page(ExternalRelatedPartiesQuery externalRelatedPartiesQuery);
    
    /**
     * 根据主键批量删除
     * @param ids
     * @return
     */
    Long del(List<Long> ids);
    
    /**
     * 获取列表查询
     * @param externalRelatedPartiesQuery
     * @return
     */
    List<ExternalRelatedPartiesVO> getList(ExternalRelatedPartiesQuery externalRelatedPartiesQuery);
    
    /**
     * 根据条件修改
     * @param externalRelatedPartiesPayload
     * @return
     */
    Long update(ExternalRelatedPartiesPayload externalRelatedPartiesPayload);
   
}

