package com.elitesland.tw.tw5.api.prd.pms.budget.vo;

import com.elitesland.tw.tw5.api.common.TwCommonVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 预算明细表VO
 *
 * @author duwh
 * @date 2024/3/7
 */
@Data
@ApiModel(description = "预算明细表vo")
public class PmsWbsBudgetDetailsVO extends TwCommonVO implements Serializable {

    @ApiModelProperty("主表 id pms_wbs_budget.id")
    private Long budgetId;
    @ApiModelProperty("主表 id pms_wbs_budget.id名称")
    private String budgetIdDesc;

    @ApiModelProperty("wbs 活动主键")
    private Long wbsId;
    @ApiModelProperty("wbs 活动主键名称")
    private String wbsIdDesc;

    @ApiModelProperty("wbs 活动名称（冗余)")
    private String wbsName;
    /**
     * wbs编码
     */
    @ApiModelProperty("wbs编码")
    private String wbsCode;

    @ApiModelProperty("wbs 活动状态(冗余)")
    private String wbsStatus;

    @ApiModelProperty("版本 id")
    private Long versionId;
    @ApiModelProperty("版本 id名称")
    private String versionIdDesc;

    @ApiModelProperty("版本号")
    private Integer versionNo;

    @ApiModelProperty("项目id")
    private Long proId;
    @ApiModelProperty("项目id名称")
    private String proIdDesc;

    @ApiModelProperty("有效关联id")
    private Long effRelateId;
    @ApiModelProperty("有效关联id名称")
    private String effRelateIdDesc;

    @ApiModelProperty("资源成本")
    private BigDecimal resCost;

    public BigDecimal getResCost() {
        if (null == resCost) {
            return BigDecimal.ZERO;
        }
        return resCost;
    }

    @ApiModelProperty("当前分配预算")
    private BigDecimal allocatedResAmt;

    public BigDecimal getAllocatedResAmt() {
        if (null == allocatedResAmt) {
            return BigDecimal.ZERO;
        }
        return allocatedResAmt;
    }

    @ApiModelProperty("剩余")
    private BigDecimal remainingResAmt;

    public BigDecimal getRemainingResAmt() {
        if (null == remainingResAmt) {
            return BigDecimal.ZERO;
        }
        return remainingResAmt;
    }


    // public BigDecimal getRemainingResAmt() {
    //     return remainingResAmt;
    // }

    @ApiModelProperty("已占用")
    private BigDecimal occupiedResAmt;

    public BigDecimal getOccupiedResAmt() {
        if (null == occupiedResAmt) {
            return BigDecimal.ZERO;
        }
        return occupiedResAmt;
    }

    @ApiModelProperty("已结算")
    private BigDecimal settledResAmt;

    public BigDecimal getSettledResAmt() {
        if (null == settledResAmt) {
            return BigDecimal.ZERO;
        }
        return settledResAmt;
    }

    @ApiModelProperty("变更量")
    private BigDecimal changeResAmt;

    public BigDecimal getChangeResAmt() {
        if (null == changeResAmt) {
            return BigDecimal.ZERO;
        }
        return changeResAmt;
    }

    @ApiModelProperty("变更后分配预算")
    private BigDecimal changedAllocatedResAmt;

    public BigDecimal getChangedAllocatedResAmt() {
        if (null == changedAllocatedResAmt) {
            return BigDecimal.ZERO;
        }
        return changedAllocatedResAmt;
    }

    @ApiModelProperty("拓展字段1")
    private String extString1;

    @ApiModelProperty("拓展字段2")
    private String extString2;

    @ApiModelProperty("拓展字段3")
    private String extString3;

    @ApiModelProperty("拓展字段4")
    private String extString4;

    @ApiModelProperty("拓展字段5")
    private String extString5;

}
