package com.elitesland.tw.tw5.api.prd.pms.payload;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.common.annotation.FieldCreateLog;
import com.elitesland.tw.tw5.api.common.annotation.FieldUpdateLog;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * 项目wbs表
 *
 * @author carl
 * @date 2023-04-06
 */
@Getter
@Setter
public class PmsProjectWbsPayload extends TwCommonPayload implements Serializable {
    /**
     * 项目主键
     */
    @ApiModelProperty("项目主键")
    private Long projectId;
    /**
     * wbs描述（名称）
     */

    @FieldCreateLog(fieldName = "节点描述")
    @FieldUpdateLog(fieldName = "节点描述")
    @ApiModelProperty("wbs描述（名称）")
    private String wbsName;
    /**
     * wbs类型(WBS,NET,ACT,MS)
     */

    @ApiModelProperty("wbs类型(WBS,NET,ACT,MS,ACTG)")
    private String wbsType;

    @FieldCreateLog(fieldName = "节点属性")
    @ApiModelProperty("wbs类型(WBS,NET,ACT,MS)")
    private String wbsTypeName;
    /**
     * wbs编码（前端传值）
     */
    @ApiModelProperty("wbs编码")
    private String wbsCode;
    /**
     * 父节点wbs码（前端传值）
     */
    @ApiModelProperty("父节点wbs码")
    private String parentWbsCode;
    /**
     * 父节点wbs名称
     */
    @FieldUpdateLog(fieldName = "上级节点")
    @ApiModelProperty("父节点wbs名称")
    private String parentWbsName;
    /**
     * 节点编码（后端生成）
     */
//    @FieldUpdateLog(fieldName = "节点编码")
//    @FieldCreateLog(fieldName = "节点编码")
    @ApiModelProperty("节点编码")
    private String nodeCode;

    /**
     * 节点负责人
     */
    @ApiModelProperty("节点负责人")
    private Long managerUserId;


    /**
     * 成本对象，勾选为1
     */
    @ApiModelProperty("成本对象，勾选为1")
    private Integer subjectDist;

    @FieldUpdateLog(fieldName = "成本对象")
    @FieldCreateLog(fieldName = "成本对象")
    private String subjectDistName;

    /**
     * 成本类型
     */
    @ApiModelProperty("成本类型")
    private String costType;
    /**
     * 成本类型
     */
    @FieldUpdateLog(fieldName = "成本类型")
    @FieldCreateLog(fieldName = "成本类型")
    @ApiModelProperty("成本类型")
    private String costTypeName;

    /**
     * 实际开始时间
     */
    @ApiModelProperty("实际开始时间")
    private LocalDate startDate;
    /**
     * 实际结束时间
     */
    @ApiModelProperty("实际结束时间")
    private LocalDate endDate;
    @ApiModelProperty("实际结束时间")
    private LocalDate endDateIsNull;

    /**
     * 实际持续时间（天）
     */
    @FieldUpdateLog(fieldName = "实际持续时间（天）")
    @FieldCreateLog(fieldName = "实际持续时间（天）")
    @ApiModelProperty("实际持续时间（天）")
    private BigDecimal durationDay;
    /**
     * 预计开始时间
     */
    @ApiModelProperty("预计开始时间")
    private LocalDate preStartDate;
    /**
     * 预计结束时间
     */
    @ApiModelProperty("预计结束时间")
    private LocalDate preEndDate;
    /**
     * 预计持续时间（天）
     */
    @ApiModelProperty("预计持续时间（天）")
    private BigDecimal preDurationDay;
    /**
     * 进度(%)
     */
    @ApiModelProperty("进度(%)")
    private BigDecimal wbsProgress;
    /**
     * 状态
     */
    @ApiModelProperty("状态")
    private String wbsStatus;

    /**
     * 已开始状态的数据 当取消的时候 显示标志改为 true
     */
    private Boolean cancelShowFlag;
    /**
     * 最早开始时间
     */
    @ApiModelProperty("最早开始时间")
    private LocalDate earlyStartDate;
    /**
     * 最早结束时间
     */
    @ApiModelProperty("最早结束时间")
    private LocalDate earlyEndDate;
    /**
     * 最晚开始时间
     */
    @ApiModelProperty("最晚开始时间")
    private LocalDate lateStartDate;
    /**
     * 最晚结束日期
     */
    @ApiModelProperty("最晚结束日期")
    private LocalDate lateEndDate;
    /**
     * 总浮时
     */
    @ApiModelProperty("总浮时")
    private BigDecimal totalFloat;
    /**
     * 自由浮时
     */
    @ApiModelProperty("自由浮时")
    private BigDecimal freeFloat;
    /**
     * 延时
     */
    @ApiModelProperty("延时")
    private BigDecimal delayLag;
    /**
     * 是否是关键节点0:否，1：是
     */
    @ApiModelProperty("是否是关键节点0:否，1：是")
    private Integer isKeyNode;
    /**
     * 是否自动排期0：未进行，1：已排期，2：已过期
     */
    @ApiModelProperty("是否自动排期0：未进行，1：已排期，2：已过期")
    private Integer autoScheduling;
    /**
     * 删除的成本评估ids
     */
    @ApiModelProperty("删除的成本评估ids")
    private List<Long> delActCostIds;
    /**
     * 删除的交付物ids
     */
    @ApiModelProperty("删除的交付物ids")
    private List<Long> delActPayIds;
    /**
     * 成本计划，勾选为1
     */
    @ApiModelProperty("成本计划，勾选为1")
    private Integer costPlan;

    @FieldUpdateLog(fieldName = "成本计划")
    private String costPlanName;

    /**
     * 开票属性，勾选为1
     */
    @ApiModelProperty("开票属性，勾选为1")
    private Integer invoiceAttr;

    @FieldUpdateLog(fieldName = "开票属性")
    private String invoiceAttrName;

    private BaseModel wbsDO;
    /**
     * 日历信息
     */
    private PmsProjectCalendarPayload pmsProjectCalendarPayload;
    /**
     * 活动交付物
     */
    @ApiModelProperty("活动交付物")
    private List<PmsWbsActPayPayload> actPayPayloads;

    /**
     * 活动成本评估
     */
    @ApiModelProperty("活动成本评估")
    private List<PmsWbsActCostPayload> actCostPayloads;

    /**
     * wbs权重
     */
    @ApiModelProperty("wbs权重")
    private BigDecimal wbsWeight;

    /**
     * wbs权重设置方式：1为手动设置  0为系统设置
     */
    @ApiModelProperty("wbs权重设置方式：1为手动设置  0为系统设置")
    private Integer manualSettingWeight;

    /**
     * wbs资源分配列表
     */
    @ApiModelProperty("wbs资源分配列表")
    private List<PmsProjectWbsResourcePayload> pmsProjectWbsResourcePayloadList;


    /**
     * wbs前置依赖
     */
    @ApiModelProperty("wbs前置依赖")
    private List<PmsProjectWbsRelyDataPayload> pmsProjectWbsRelyDataPayloadList;

    /**
     * 版本id
     */
    @ApiModelProperty("版本id")
    private Long versionId;


    /**
     * 版本号
     */
    @ApiModelProperty("版本号")
    private Integer versionNo;

    /**
     * 父主键
     */
    @ApiModelProperty("父主键")
    private Long parentId;

    /**
     * 状态 0草稿 1提交
     */
    @ApiModelProperty("状态 0草稿 1提交 2已取消")
    private String state;

    /**
     * 相关资源
     */
    @ApiModelProperty("相关资源")
    private String relatePartiesIds;


    @ApiModelProperty("有效关联id")
    private Long effRelateId;

    @ApiModelProperty("预算释放标记 true 已释放  false 未释放（default）")
    private Boolean releaseFlag;

    /**
     * 收款计划ID
     */
    @ApiModelProperty("收款计划ID")
    private Long receivePlanId;

    /**
     * 规划当量
     */
    @ApiModelProperty("规划当量")
    private BigDecimal planEqva;

    @ApiModelProperty("原始规划当量")
    private BigDecimal originalPlanEqva;

    /**
     * 拨付状态
     */
    @ApiModelProperty("拨付状态")
    private String allocateStatus;

    /**
     * 拨付当量
     */
    @ApiModelProperty("拨付当量")
    private BigDecimal allocateEqva;

    /**
     * 拨款金额
     */
    @ApiModelProperty("拨款金额")
    private BigDecimal allocateCost;

    /**
     * 明细控制
     */
    @ApiModelProperty("明细控制 ")
    private Boolean detailControlFlag;


    @ApiModelProperty("变更备注")
    private String changeRemark;

    @ApiModelProperty("占用当量数")
    private BigDecimal occupyEqva;
    @ApiModelProperty("已使用当量数")
    private BigDecimal usedEqva;

    @ApiModelProperty("使用当量占比")
    private BigDecimal usedEqvaProportion;


    @ApiModelProperty("使用费用占比")
    private BigDecimal usedAmtProportion;

}
