package com.elitesland.tw.tw5.api.prd.pms.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 项目wbs表
 *
 * @author carl
 * @date 2023-04-06
 */
@Getter
@Setter
public class PmsProjectWbsRelyDataPayload extends TwCommonPayload implements Serializable {
    /**
     * wbs主键
     */
    @ApiModelProperty("wbs主键")
    private Long wbsId;
    /**
     * 新增的前置依赖wbsIds
     */
    @ApiModelProperty("新增的前置依赖wbsIds")
    private List<Long> addWbsRelyIds;
    /**
     * 前置类型（FS）
     */
    @ApiModelProperty("前置类型（FS）")
    private String relyType;


    /**
     * 版本id
     */
    @ApiModelProperty("版本id")
    private Long versionId;

    /**
     * 版本号
     */
    @ApiModelProperty("版本号")
    private Integer versionNo;

    /**
     * wbs编码
     */
    @ApiModelProperty("wbs编码")
    private String wbsCode;

    /**
     * 新增的前置依赖wbsCodes
     */
    @ApiModelProperty("新增的前置依赖wbsCodes")
    private List<String> addWbsRelyCodes;
}
