package com.elitesland.tw.tw5.api.prd.pms.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 项目集管理
 *
 * @author carl
 * @date 2023-07-03
 */
@Getter
@Setter
public class PmsProjectSetQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 父主键 精确
     */
    @ApiModelProperty("父主键")
    private Long parentId;
    /**
     * 项目集名称 模糊
     */
    @ApiModelProperty("项目集名称")
    private String setName;
    /**
     * 项目集搜索 模糊
     */
    @ApiModelProperty("项目集搜索")
    private String setSearch;
    /**
     * 项目集信息码 模糊
     */
    @ApiModelProperty("项目集信息码")
    private String setCode;
    /**
     * 项目集信息父节点码 模糊
     */
    @ApiModelProperty("项目集信息父节点码")
    private String parentSetCode;
    /**
     * node码 模糊
     */
    @ApiModelProperty("node码")
    private String nodeCode;
    /**
     * 负责人id 精确
     */
    @ApiModelProperty("负责人id")
    private Long managerUserId;
}
