package com.elitesland.tw.tw5.api.prd.pms.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * wbs模板节点
 *
 * @author Echo
 * @date 2023-03-29
 */
@Getter
@Setter
public class PmsWbsTemplateNodeQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    @Query
    private Long id;
    /** 模板主键 精确 */
    @ApiModelProperty("模板主键")
    @Query
    private Long templateId;
    /** 节点描述（名称） 精确 */
    @ApiModelProperty("节点描述（名称）")
    @Query
    private String wbsName;
    /** 节点类型(WBS,NET,ACT,MS) 精确 */
    @ApiModelProperty("节点类型(WBS,NET,ACT,MS)")
    @Query
    private String wbsType;
    /** 节点编码 精确 */
    @ApiModelProperty("节点编码")
    @Query
    private String nodeCode;
    /** wbs码 精确 */
    @ApiModelProperty("wbs码")
    @Query
    private String wbsCode;
    /** 父级wbs码 精确 */
    @ApiModelProperty("父级wbs码")
    @Query
    private String parentWbsCode;
}
