package com.elitesland.tw.tw5.api.prd.pms.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsBudgetSubjectPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsBudgetSubjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsBudgetSubjectVO;

import java.util.List;

/**
 * 预算科目
 *
 * @author xxb
 * @date 2023-04-23
 */
public interface PmsBudgetSubjectService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsBudgetSubjectVO}>
     */
    PagingVO<PmsBudgetSubjectVO> queryPaging(PmsBudgetSubjectQuery query);

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsBudgetSubjectVO}>
     */
    PagingVO<PmsBudgetSubjectVO> pagingByTree(PmsBudgetSubjectQuery query);

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsBudgetSubjectVO}>
     */
    List<PmsBudgetSubjectVO> listByTree(PmsBudgetSubjectQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsBudgetSubjectVO}>
     */
    List<PmsBudgetSubjectVO> queryListDynamic(PmsBudgetSubjectQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PmsBudgetSubjectVO}
     */
    PmsBudgetSubjectVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PmsBudgetSubjectVO}
     */
    PmsBudgetSubjectVO insert(PmsBudgetSubjectPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 更改科目状态 0正常  1弃用
     *
     * @param keys 主键集合
     */
    void updateSubjectStatus(Long[] keys,Integer subjectStatus);

}
