package com.elitesland.tw.tw5.api.prd.pms.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectSetDataPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectSetPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectSetQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectSetRelationVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectSetVO;


import java.util.List;

/**
 * 项目集管理
 *
 * @author carl
 * @date 2023-07-03
 */
public interface PmsProjectSetService {


    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsProjectSetVO}>
     */
    List<PmsProjectSetVO> queryListDynamic(PmsProjectSetQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsProjectSetVO}>
     */
    List<PmsProjectSetVO> queryListToProject(PmsProjectQuery query);

    /**
     * 提供选择项查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsProjectSetVO}>
     */
    List<PmsProjectSetVO> querySelectList(PmsProjectSetQuery query);

    /**
     * 提供选择项查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsProjectSetVO}>
     */
    PagingVO<PmsProjectSetRelationVO> queryRelationProjectPaging(PmsProjectSetQuery query);

    /**
     * 提供选择项查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsProjectSetVO}>
     */
    List<PmsProjectSetRelationVO> queryRelationProjectList(PmsProjectSetQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PmsProjectSetVO}
     */
    PmsProjectSetVO queryByKey(Long key);

    /**
     * 新增或编辑
     *
     * @param payload 单据数据
     * @return {@link PmsProjectSetVO}
     */
    PmsProjectSetVO insertOrUpdate(PmsProjectSetDataPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PmsProjectSetVO}
     */
    PmsProjectSetVO update(PmsProjectSetPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(PmsProjectSetPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    void udateSetCode(Long id,String setCode);

}
