package com.elitesland.tw.tw5.api.prd.pms.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;


/**
 * 项目wbs表
 *
 * @author carl
 * @date 2023-04-06
 */
@Getter
@Setter
public class PmsProjectWbsVO extends BaseViewModel implements Serializable {
    /**
     * 项目主键
     */
    @ApiModelProperty("项目主键")
    private Long projectId;

    /**
     * wbs描述（名称）
     */
    @ApiModelProperty("wbs描述（名称）")
    private String wbsName;
    /**
     * wbs类型(WBS,NET,ACT,MS,ACTG)
     */
    @ApiModelProperty("wbs类型(WBS,NET,ACT,MS,ACTG)")
    private String wbsType;
    /**
     * wbs编码
     */
    @ApiModelProperty("wbs编码")
    private String wbsCode;
    /**
     * node码
     */
    @ApiModelProperty("node码")
    private String nodeCode;
    /**
     * 父节点
     */
    @ApiModelProperty("父节点")
    private String parentWbsCode;
    /**
     * 父节点wbs名称
     */
    @ApiModelProperty("父节点wbs名称")
    private String parentWbsName;

    /**
     * 节点负责人
     */
    @ApiModelProperty("节点负责人")
    private Long managerUserId;
    /**
     * 节点负责人
     */
    @ApiModelProperty("节点负责人")
    private String managerUserName;
    /**
     * 成本对象，勾选为1
     */
    @ApiModelProperty("成本对象，勾选为1")
    private Integer subjectDist;


    /**
     * 成本类型
     */
    @ApiModelProperty("成本类型")
    private String costType;
    /**
     * 成本类型
     */
    @ApiModelProperty("成本类型")
    private String costTypeName;


    /**
     * 实际开始时间
     */
    @ApiModelProperty("实际开始时间")
    private LocalDate startDate;
    /**
     * 实际结束时间
     */
    @ApiModelProperty("实际结束时间")
    private LocalDate endDate;

    /**
     * 实际持续时间（天）
     */
    @ApiModelProperty("实际持续时间（天）")
    private BigDecimal durationDay;
    /**
     * 预计开始时间
     */
    @ApiModelProperty("预计开始时间")
    private LocalDate preStartDate;
    /**
     * 预计结束时间
     */
    @ApiModelProperty("预计结束时间")
    private LocalDate preEndDate;
    /**
     * 预计持续时间（天）
     */
    @ApiModelProperty("预计持续时间（天）")
    private BigDecimal preDurationDay;
    /**
     * 最早开始时间
     */
    @ApiModelProperty("最早开始时间")
    private LocalDate earlyStartDate;
    /**
     * 最早结束时间
     */
    @ApiModelProperty("最早结束时间")
    private LocalDate earlyEndDate;
    /**
     * 最晚开始时间
     */
    @ApiModelProperty("最晚开始时间")
    private LocalDate lateStartDate;
    /**
     * 最晚结束日期
     */
    @ApiModelProperty("最晚结束日期")
    private LocalDate lateEndDate;
    /**
     * 总浮时
     */
    @ApiModelProperty("总浮时")
    private BigDecimal totalFloat;
    /**
     * 自由浮时
     */
    @ApiModelProperty("自由浮时")
    private BigDecimal freeFloat;
    /**
     * 延时
     */
    @ApiModelProperty("延时")
    private BigDecimal delayLag;
    /**
     * 是否是关键节点0:否，1：是
     */
    @ApiModelProperty("是否是关键节点0:否，1：是")
    private Integer isKeyNode;
    /**
     * 是否自动排期0：未进行，1：已排期，2：已过期
     */
    @ApiModelProperty("是否自动排期0：未进行，1：已排期，2：已过期")
    private Integer autoScheduling;
    /**
     * 进度(%)
     */
    @ApiModelProperty("进度(%)")
    private BigDecimal wbsProgress;
    /**
     * 状态
     */
    @ApiModelProperty("状态")
    private String wbsStatus;

    /**
     * 已开始状态的数据 当取消的时候 显示标志改为 true
     */
    private Boolean cancelShowFlag;
    /**
     * 状态
     */
    @ApiModelProperty("状态")
    private String wbsStatusName;

    /**
     * 成本计划，勾选为1
     */
    @ApiModelProperty("成本计划，勾选为1")
    private Integer costPlan;


    /**
     * 开票属性，勾选为1
     */
    @ApiModelProperty("开票属性，勾选为1")
    private Integer invoiceAttr;

    /**
     * 活动成本评估
     */
    @ApiModelProperty("活动成本评估")
    private List<PmsWbsActCostVO> actCostVOs;


    /**
     * 活动交付物
     */
    @ApiModelProperty("活动交付物")
    private List<PmsWbsActPayVO> actPayVOs;

    /**
     * wbs权重
     */
    @ApiModelProperty("wbs权重")
    private BigDecimal wbsWeight;

    /**
     * 节点预算状态
     */
    @ApiModelProperty("节点预算状态")
    private String budgetStatus;

    /**
     * 费用总预算
     */
    @ApiModelProperty("费用总预算")
    private BigDecimal totalMoney;
    /**
     * 使用占比=已使用预算金额/预算总金额
     */
    @ApiModelProperty("使用占比=已使用预算金额/预算总金额")
    private BigDecimal proportion;
    /**
     * 已使用预算金额=已经报销完成的金额
     */
    @ApiModelProperty("已使用预算金额=已经报销完成的金额")
    private BigDecimal usedMoney;

    /**
     * 所有的前置依赖wbsIds
     */
    @ApiModelProperty("所有的前置依赖wbsIds")
    private String frontWbsIds;
    /**
     * 所有的前置依赖关系Ids
     */
    @ApiModelProperty("所有的前置依赖关系Ids")
    private String frontRelyIds;

    /**
     * 权重设置方式：1为手动设置  0为系统设置
     */
    @ApiModelProperty("wbs权重设置方式：1为手动设置  0为系统设置")
    private Integer manualSettingWeight = 0;

    @ApiModelProperty("有没有任务标志")
    private Boolean hasTaskFlag;


    @ApiModelProperty("有没有验收标准标志 false没有 true有")
    private Boolean hasAcceptFlag;

    @ApiModelProperty("分配资源人员集合")
    private List<PmsProjectWbsResourceVO> pmsProjectWbsResourceVOList;

    @ApiModelProperty("前置依赖集合")
    private List<PmsProjectWbsRelyVO> pmsProjectWbsRelyVOList;

    @Override
    public String toString() {
        return "PmsProjectWbsVO{" +
                "wbsName='" + wbsName + '\'' +
                ", preDurationDay=" + preDurationDay +
                ", earlyStartDate=" + earlyStartDate +
                ", earlyEndDate=" + earlyEndDate +
                ", lateStartDate=" + lateStartDate +
                ", lateEndDate=" + lateEndDate +
                ", totalFloat=" + totalFloat +
                ", freeFloat=" + freeFloat +
                ", isKeyNode=" + isKeyNode +
                ", autoScheduling=" + autoScheduling +
                '}';
    }

//    /**
//     * 本节点所有前置正推最早的开始时间
//     */
//    @ApiModelProperty("本节点所有前置正推最早的开始时间")
//    private Map<String, LocalDate> earlyStartMap = new HashMap<>();
//    /**
//     * 本节点所有前置正推最早的开始时间
//     */
//    @ApiModelProperty("本节点所有后置反推最晚的结束时间合集")
//    private Map<String, LocalDate> lateEndMap = new HashMap<>();


    /**
     * 版本id
     */
    @ApiModelProperty("版本id")
    private Long versionId;


    /**
     * 版本号
     */
    @ApiModelProperty("版本号")
    private Integer versionNo;


    @ApiModelProperty("状态 0草稿 1提交 2已取消")
    private String state;


    @ApiModelProperty("有效关联id")
    private Long effRelateId;

    @ApiModelProperty("预算释放标记 true 已释放  false 未释放（default）")
    private Boolean releaseFlag;

    /**
     * 收款计划ID
     */
    @ApiModelProperty("收款计划ID")
    private Long receivePlanId;


    /**
     * 收款计划阶段描述
     */
    @ApiModelProperty("收款计划阶段描述")
    private String receivePlanDesc;

    /**
     * 拨付状态 com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjWbsAllocateStateEnum
     */
    @ApiModelProperty("拨付状态")
    private String allocateStatus;

    /**
     * 拨付状态 com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjWbsAllocateStateEnum
     */
    @ApiModelProperty("项目活动拨付状态")
    private String allocateStatusDesc;

    /**
     * 规划当量
     */
    @ApiModelProperty("规划当量")
    private BigDecimal planEqva;

    @ApiModelProperty("原始规划当量")
    private BigDecimal originalPlanEqva;


    @ApiModelProperty("已派发当量")
    private BigDecimal distedEqva;


    @ApiModelProperty("拨付当量")
    private BigDecimal allocateEqva;

    /**
     * 当期收款比例
     */
    @ApiModelProperty("当期收款比例")
    private BigDecimal receRatio;

    /**
     * 当期收款金额
     */
    @ApiModelProperty("当期收款金额")
    private BigDecimal receAmt;

    /**
     * 收款状态
     */
    @ApiModelProperty("收款状态")
    private String receStatus;
    @ExcelProperty(index = 6, value = "收款状态")
    private String receStatusDesc;

    /**
     * 预计收款日期
     */
    @ApiModelProperty("预计收款日期")
    private LocalDate expectReceDate;

    /**
     * 预计收款日期
     */
    @ApiModelProperty("判断收款的预计收款日期在不在阶段的起止日期内 1在 0不在")
    private int expectReceDateFlag;


    @ApiModelProperty("拨付费用")
    private BigDecimal allocateCost;

    @ApiModelProperty("版本变更值相关")
    private Map<String, BigDecimal> changeInfo;


    @ApiModelProperty("变更前")
    private BigDecimal beforeValue;
    @ApiModelProperty("差异")
    private BigDecimal deltaValue;
    @ApiModelProperty("变更后")
    private BigDecimal afterValue;

    /**
     * 明细控制
     */
    @ApiModelProperty("明细控制 ")
    private Boolean detailControlFlag;

    @ApiModelProperty("占用当量数")
    private BigDecimal occupyEqva;
    @ApiModelProperty("已使用当量数")
    private BigDecimal usedEqva;
    @ApiModelProperty("使用当量占比")
    private BigDecimal usedEqvaProportion;


    @ApiModelProperty("变更备注")
    private String changeRemark;

    @ApiModelProperty("收款计划")
    private List<ConReceivablePlanVO> planVOS;

    /**
     * 预计成本 活动的预计成本 = 各资源的（预计工期 *投入精力 *当量系数）之和
     */
    private BigDecimal resCostSum;
    /**
     * 行id，wbs导入导出用
     */
    private Integer rowId;
}
