package com.elitesland.tw.tw5.api.prd.purchase.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 采购合同终止
 *
 * @author lemon
 * @date 2023-10-19
 */
@Getter
@Setter
public class TPurchaseContractOverQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 合同终止编号 精确 */
    @ApiModelProperty("合同终止编号")
    private String overNo;
    /** 申请人资源ID 精确 */
    @ApiModelProperty("申请人资源ID")
    private Long applyResId;
    /** 合同终止状态 精确 */
    @ApiModelProperty("合同终止状态")
    private String overStatus;
    /** 采购合同ID 精确 */
    @ApiModelProperty("采购合同ID")
    private Long contractId;
    /** 采购合同编号 精确 */
    @ApiModelProperty("采购合同编号")
    private String contractNo;
    /** 终止原因 精确 */
    @ApiModelProperty("终止原因")
    private String overWhy;
    /** 终止日期 精确 */
    @ApiModelProperty("终止日期")
    private LocalDate overTime;
    /** 流程实例ID 精确 */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /** 流程审批状态 精确 */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /** 提交时间 精确 */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /** 审批时间 精确 */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;
}
