package com.elitesland.tw.tw5.api.prd.schedule.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 活动日历
 *
 * @author vincent
 * @date 2024-04-22
 */
@Getter
@Setter
public class PrdActivityCalendarPayload extends TwCommonPayload implements Serializable {
    /**
     * 活动标题
     */
    @NotBlank
    @ApiModelProperty("活动标题")
    private String title;
    /**
     * 活动类型
     */
    @NotBlank
    @ApiModelProperty("活动类型")
    private String type;
    /**
     * 开始时间
     */
    @NotNull
    @ApiModelProperty("开始时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm")
    private LocalDateTime startTime;
    /**
     * 结束时间
     */
    @NotNull
    @ApiModelProperty("结束时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm")
    private LocalDateTime endTime;
    /**
     * 活动城市
     */
    @NotBlank
    @ApiModelProperty("活动城市")
    private String city;
    /**
     * 活动地点
     */
    @ApiModelProperty("活动地点")
    private String location;
    /**
     * 活动规模
     */
    @NotBlank
    @ApiModelProperty("活动规模")
    private String scale;
    /**
     * 活动负责人
     */
    @ApiModelProperty("活动负责人")
    private Long manageUserId;
    /**
     * 参与人
     */
    @ApiModelProperty("参与人")
    private List<Long> participantsList;

    @JsonIgnore
    private String participants;
    /**
     * 直播地址
     */
    @ApiModelProperty("直播地址")
    private String liveUrl;
}
