package com.elitesland.tw.tw5.api.prd.system.vo;

import com.elitesland.tw.tw5.api.common.util.TreeInterface;
import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
public class PrdSystemMenuVO extends BaseViewModel implements TreeInterface<PrdSystemMenuVO>, Cloneable {

    //
    @ApiModelProperty("上级菜单id")
    private Long parentId;

    @ApiModelProperty("上级菜单名称")
    private String parentName;

    @ApiModelProperty("菜单编号")
    private String menuCode;

    @ApiModelProperty("菜单名称")
    private String menuName;

    @ApiModelProperty("菜单前端路由")
    private String portalRoute;

    @ApiModelProperty("菜单图标")
    private String menuIcon;

    @ApiModelProperty("菜单排序")
    private Integer sortIndex;

    @ApiModelProperty("菜单状态")
    private Integer menuStatus = 0;
    /**
     * 子节点
     */
    private List<PrdSystemMenuVO> children;

    @ApiModelProperty("菜单类型")
    private String menuType;


    @Override
    public List<PrdSystemMenuVO> getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(List<PrdSystemMenuVO> children) {
        this.children = children;
    }

    @Override
    public Object getParentCode() {
        return this.getParentId();
    }

    @Override
    public Object getCode() {
        return getId();
    }
}
