package com.elitesland.tw.tw5.api.prd.acc.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.tw.tw5.api.prd.borrow.vo.BorrowMoneyVO;
import com.elitesland.tw.tw5.api.prd.borrow.vo.BorrowWriteOffVO;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;


/**
 * 费用报销管理
 *
 * @author sunxw
 * @date 2023-11-22
 */
@Data
@ExcelIgnoreUnannotated
public class AccReimVO extends BaseViewModel implements Serializable {

    @ApiModelProperty("报销单号")
    @ExcelProperty(value = "报销单号", index = 1)
    private String reimNo;

    @ApiModelProperty("报销人USER_ID")
    private Long reimUserId;

    @UdcName(udcName = "USER", codePropName = "reimUserId")
    @ExcelProperty(value = "报销人", index = 2)
    private String reimUserName;

    @ApiModelProperty("报销人ORG_ID")
    private Long reimOrgId;
    @UdcName(udcName = "BU", codePropName = "reimOrgId")
    private String reimOrgName;

    @ApiModelProperty("报销人职级")
    private String reimResGrade;

    @ApiModelProperty("报销类型")
    private String reimType;
    @UdcName(udcName = "ACC:REIM_TYPE", codePropName = "reimType")
    private String reimTypeName;

    @ApiModelProperty("单据类型")
    private String reimDocType;
    @UdcName(udcName = "ACC:REIM_PROC_KEY", codePropName = "reimDocType")
    @ExcelProperty(value = "单据类型", index = 3)
    private String reimDocTypeName;

    @ApiModelProperty("相关申请单")
    private Long relatedDocId;

    @ApiModelProperty("相关申请单名称")
    private String relatedDocName;

    @ApiModelProperty("相关预算")
    private Long relatedBudgetId;
    private String relatedBudgetName;

    /**
     * 费用归属 【P_reim_.expense_classification】
     */
    @ApiModelProperty("费用归属")
    private String expenseClassification;

    @ApiModelProperty("费用承担项目")
    private Long expenseProjectId;

    @ApiModelProperty("费用承担部门")
    private Long expenseOrgId;
    @UdcName(udcName = "BU", codePropName = "expenseOrgId")
    private String expenseOrgName;

    @ApiModelProperty("费用承担公司")
    private Long expenseCompany;
    private String expenseCompanyName;

    @ApiModelProperty("记账日期")
    private LocalDateTime accountingDate;

    @ApiModelProperty("报销单状态")
    private String reimStatus;
    @UdcName(udcName = "ACC:REIM_STATUS", codePropName = "reimStatus")
    @ExcelProperty(value = "报销单状态", index = 4)
    private String reimStatusName;

    @ApiModelProperty("报销说明")
    private String reimRemark;

    @ApiModelProperty("报销总额")
    @ExcelProperty(value = "报销费用", index = 6)
    private BigDecimal reimTotalAmt;

    @ApiModelProperty("调整后费用")
    private BigDecimal adjustAmt;

    @ApiModelProperty("借款核销金额")
    @ExcelProperty(value = "借款核销金额", index = 7)
    private BigDecimal  borrowWriteOffAmt;

    @ApiModelProperty("实际请款金额")
    @ExcelProperty(value = "实际请款金额", index = 8)
    private BigDecimal payAmt;

    @ApiModelProperty("付款日期")
    private LocalDateTime payDate;

    @ApiModelProperty("事由类型")
    private String reasonType;
    @UdcName(udcName = "PMS:PROJECT:TYPE", codePropName = "reasonType")
    private String reasonTypeName;

    @ApiModelProperty("事由号")
    private Long reasonId;

    @ApiModelProperty("事由名称")
    private String reasonName;

    @ApiModelProperty("付款方式")
    private String payMethod;
    @UdcName(udcName = "ACC:PAY_METHOD", codePropName = "payMethod")
    private String payMethodName;

    @ApiModelProperty("收款账户")
    private String accountNo;

    @ApiModelProperty("户名")
    private String holderName;

    @ApiModelProperty("收款银行")
    private String bankName;

    @ApiModelProperty("收款银行网点")
    private String bankBranch;

    @ApiModelProperty("支付方式：1.网银支付 2.手动支付")
    private String payMode;
    @UdcName(udcName = "ACC:PAY_MODE", codePropName = "payMode")
    private String payModeName;

    @ApiModelProperty("付款银行账号")
    private String payAccountNo;

    @ApiModelProperty("客户承担费用")
    private String expenseByType;
    @UdcName(udcName = "salecon:cust_bear", codePropName = "expenseByType")
    private String expenseByTypeName;

    @ApiModelProperty("审批状态")
    private String apprStatus;
    @UdcName(udcName = "appr_status", codePropName = "apprStatus")
    @ExcelProperty(value = "审批状态", index = 5)
    private String apprStatusName;

    @ApiModelProperty("流程实例id")
    private String procInstId;

    @ApiModelProperty("流程实例名称")
    private String procInstName;

    @ApiModelProperty("财务收单时间")
    private LocalDateTime finChargeUpTime;

    @ApiModelProperty("报销导出批次号，T_ACC_PAY_BATCH.BATCH_NO")
    private String batchNo;

    @ApiModelProperty("新批次号 作为付款时用，与记账做区分")
    private String batchNoLast;

    @ApiModelProperty("支付状态：S 成功、F 失败、C 撤销、D 过期、R 否决 G退票")
    private String payStatus;
    @UdcName(udcName = "purchase:slip:pay_status", codePropName = "payStatus")
    private String payStatusName;

    @ApiModelProperty("网银提交标识 1.已提交 2.未提交")
    private Integer bankFlag;
    private Integer bankFlagName;

    @ApiModelProperty("网银提交时间")
    private LocalDateTime bankTime;

    @ApiModelProperty("附件")
    private String fileCode;

    @ApiModelProperty("附件数据")
    private Object fileData;

    @ApiModelProperty("申请日期")
    private LocalDate applyDate;

    @ApiModelProperty("申请日期")
    @ExcelProperty(value = "填报日期", index = 0)
    private String applyDateStr;

    public String getApplyDateStr() {
        if (applyDate != null) {
            return applyDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        return applyDateStr;
    }


    @ApiModelProperty("财务负责人审批时间")
    private LocalDateTime finPicApprTime;

    @ApiModelProperty("流程节点名称")
    private String apprProcName;

    @ApiModelProperty("是否有票")
    private Boolean invFlag = true;

    @ApiModelProperty("科目模版id")
    private Long subjectTemplId;

    private List<AccReimDetailVO> details;

    @ApiModelProperty("行政订票单ID集合")
    private List<Long> tripTicketIds;

    private Long contractId;

    @ApiModelProperty("报销人base地")
    private String baseCityName;

    @ApiModelProperty("报销人所属公司")
    private String baseOuName;

    @ApiModelProperty("相关项目/参考合同号")
    private String relateProjAndConNO;

    @ApiModelProperty("合同签约公司")
    private String conSignOuName;

    @ApiModelProperty("当前审批的节点key")
    private String currentTaskKey;

    @ApiModelProperty("财务期间ID")
    private Long finPeriodId;
    @ApiModelProperty("财务期间名称")
    private String finPeriodName;

    @ApiModelProperty("资源编号")
    private String resNo;

    @ApiModelProperty("财务稽核专员退回标记 0-未退回 1-退回")
    private Integer finRejectFlag;

    /**
     * 删除标记 -> 方法判断时使用
     */
    private Boolean delFlag = false;


    @ApiModelProperty("财务代收单的流程节点key")
    private String procTaskKey;

    @ApiModelProperty("是否异常")
    private Integer abnormalFlag;

    @ApiModelProperty("报销明细是否需要事由")
    private Integer reimDetailFlag;

    /** 扩展字段1 */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /** 扩展字段2 */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /** 扩展字段3 */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /** 扩展字段4 */
    @ApiModelProperty("扩展字段4")
    private String ext4;
    /** 扩展字段5 */
    @ApiModelProperty("扩展字段5")
    private String ext5;
    /** 扩展字段6 */
    @ApiModelProperty("扩展字段6")
    private String ext6;

    /** 借款列表 */
    @ApiModelProperty("借款列表")
    private List<BorrowMoneyVO> borrowMoneyVOList;

    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

}
