package com.elitesland.tw.tw5.api.prd.crm.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

/**
 * 客户经营-经营计划参与者
 *
 * @author duwh
 * @date 2022/11/21
 */
@Data
public class CrmOperationPlanDetailMemberPayload extends TwCommonPayload {

    /**
     * 客户经营主键
     */
    private Long operId;

    /**
     * 经营计划明细主键
     */
    private Long planDetailId;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 用户名字 冗余
     */
    private String userName;

    /**
     * 用户头像
     */
    private String userLogo;

    /**
     * 授权开始时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime startTime;

    /**
     * 授权开始结束
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime endTime;

    /**
     * 禁用标记，0：未禁用，1：已禁用
     */
    private Integer disabledFlag = 0;

    /**
     * 已读标记，0：未读，1：已读
     */
    private Integer readFlag = 0;

    private String ext1;

    private String ext2;

    private String ext3;

    private String ext4;

    private String ext5;

}
