package com.elitesland.tw.tw5.api.prd.crm.payload;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author carl.wang
 * @Description 商机表
 * @Date
 **/
@Getter
@Setter
@ExcelIgnoreUnannotated
public class CrmOpportunityExcelExport implements Serializable {
    @ExcelProperty(index = 0, value = "序号")
    private String order;
    /**
     * 项目编号（活动编号）
     */
    @ExcelProperty(index = 1, value = "项目编号")
    private String projectNo;
    /**
     * 项目名称（名称）
     */
    @ExcelProperty(index = 2, value = "项目名称")
    private String projectName;
    /**
     * 商机级别
     */
    @ExcelProperty(index = 3, value = "商机级别")
    private String oppoLevelName;
    /**
     * 销售产品
     */
    @ExcelProperty(index = 4, value = "销售产品")
    private String saleProduct;
    /**
     * 签单bu名称
     */
    @ExcelProperty(index = 5, value = "签单BU")
    private String orgName;
    /**
     * 交付bu
     */
    @ExcelProperty(index = 6, value = "交付bu")
    private String deliOrgName;
    /**
     * 成单概率名称
     */
    @ExcelProperty(index = 7, value = "成单概率")
    private String probabilityName;
    /**
     * 预计成单日期
     */
//    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ExcelProperty(index = 8, value = "预计成单日期")
    private String forecastWinDateStr;
    /**
     * 预计签单金额
     */
    @ExcelProperty(index = 9, value = "预计签单金额")
    private BigDecimal forecastAmount;
    /**
     * 销售阶段
     */
    @ExcelProperty(index = 10, value = "销售阶段")
    private String salePhaseName;
    /**
     * 项目状态名称
     */
    @ExcelProperty(index = 11, value = "商机状态")
    private String projectStatusName;

    @ExcelProperty(index = 12, value = "验证状态")
    private String checkStatusName;
    /**
     * 客户名称
     */
    @ExcelProperty(index = 13, value = "客户名称")
    private String custBookName;
    /**
     * 客户行业名
     */
    @ExcelProperty(index = 14, value = "客户行业")
    private String custIdstName;
    /**
     * 币种名称
     */
    @ExcelProperty(index = 15, value = "币种")
    private String currCodeName;
    /**
     * 签单负责人
     */
    @ExcelProperty(index = 16, value = "签单负责人")
    private String manageUserName;
    /**
     * 售前bu
     */
    @ExcelProperty(index = 17, value = "售前bu")
    private String preSaleOrgName;

    /**
     * 售前负责人
     */
    @ExcelProperty(index = 18, value = "售前负责人")
    private String preSaleUserName;

    /**
     * 交付负责人
     */
    @ExcelProperty(index = 19, value = "交付负责人")
    private String deliUserName;

    /**
     * 客户区域名称
     */
    @ExcelProperty(index = 20, value = "客户区域")
    private String custRegionName;
    /**
     * 项目难度
     */
    @ExcelProperty(index = 21, value = "项目难度")
    private String projectDifficultName;
    /**
     * 项目重要度
     */
    @ExcelProperty(index = 22, value = "项目重要度")
    private String projectImportanceName;

    /**
     * 创建人（报备人）
     */
    @ExcelProperty(index = 23, value = "报备人")
    private String createUserName;

    /**
     * 报备日期
     */
    @ExcelProperty(index = 24, value = "报备日期")
    private String createDateStr;

    /**
     * 商机文件夹 对应在易稻壳itemId
     */
//    private String itemId;


    /**
     * 活动id
     */
//    private Long actId;

    /**
     * 活动名称
     */
//    private String actName;


    /**
     * 签单负责人id
     */
//    private Long manageUserId;


    /**
     * 签单buid
     */
//    private Long orgId;

    /**
     * 公司id
     */
//    private Long companyId;
//    /**
//     * 附件地址codes（“，”分割字符串）
//     */
//    @ExcelProperty(index = 56, value = "附件地址")
//    private String fileCodes;

    /**
     * 项目状态
     */
//    @ExcelProperty(index = 5, value = "项目状态")
//    private String projectStatus;


    /**
     * 关闭原因
     */
//    private String closeReason;
//    /**
//     * 关闭原因
//     */
//    @ExcelProperty(index = 6, value = "关闭原因")
//    private String closeReasonName;
//    /**
//     * 丢单原因
//     */
////    private String loseReason;
//    /**
//     * 丢单原因
//     */
//    @ExcelProperty(index = 8, value = "丢单原因")
//    private String loseReasonName;
//    /**
//     * 关闭备注
//     */
//    @ExcelProperty(index = 7, value = "关闭备注")
//    private String clsoeRemark;
//
//    /**
//     * 线索id
//     */
////    private Long leadsId;
//    /**
//     * 线索名称
//     */
//    @ExcelProperty(index = 9, value = "线索名称")
//    private String leadsName;
//
//    /**
//     * 客户区域
//     */
////    private String custRegion;
//
//    /**
//     * 是否老客户 0:Y,1:N
//     */
//    @ExcelProperty(index = 12, value = "是否老客户")
//    private String isOldCust;
//    /**
//     * 是否老客户 0:Y,1:N
//     */
//    private String isOldCustStr;
//
//    /**
//     * 客户id 老客户才会选择
//     */
////    private Long custBookId;
//
//    /**
//     * 客户项目
//     */
//    @ExcelProperty(index = 14, value = "客户项目")
//    private String custProject;
//    /**
//     * 客户联系人
//     */
//    @ExcelProperty(index = 15, value = "客户联系人")
//    private String contactName;
//    /**
//     * 客户联系电话
//     */
////    private String contactPhone;
//    /**
//     * 客户联系人部门
//     */
//    @ExcelProperty(index = 16, value = "客户联系人部门")
//    private String contactDept;
//    /**
//     * 客户联系人岗位
//     */
//    @ExcelProperty(index = 17, value = "客户联系人岗位")
//    private String contactPosition;
//    /**
//     * 企业主页
//     */
//    @ExcelProperty(index = 18, value = "企业主页")
//    private String contactWebsite;
//    /**
//     * 客户性质
//     */
////    @ExcelProperty(index = 19,value = "客户性质")
////    private String custProp;
//    /**
//     * 客户性质名称
//     */
//    @ExcelProperty(index = 19, value = "客户性质")
//    private String custPropName;
//    /**
//     * 客户行业
//     */
////    private String custIdst;
//
//
//    /**
//     * 成单概率
//     */
////    private String probability;
//
//    /**
//     * 币种
//     */
////    private String currCode;
//
//    /**
//     * 销售阶段
//     */
////    private String salePhase;
//
//    /**
//     * 交付地点
//     */
//    @ExcelProperty(index = 26, value = "交付地点")
//    private String deliveryAddress;
//    /**
//     * 商机级别
//     */
////    private String oppoLevel;
//    /**
//     * 是否需要合作伙伴 0:Y,1:N
//     */
//    @ExcelProperty(index = 28, value = "是否需要合作伙伴")
//    private String isNeedPartnerStr;
//    /**
//     * 关联合作伙伴Id
//     */
////    private Long coopBookId;
//    /**
//     * 关联合作伙伴名称
//     */
//    @ExcelProperty(index = 29, value = "关联合作伙伴名称")
//    private String coopBookName;
//    /**
//     * 合作伙伴描述
//     */
//    @ExcelProperty(index = 30, value = "合作伙伴描述")
//    private String partnerDesc;
//    /**
//     * 售前bu
//     */
////    private Long preSaleOrgId;
//
//    /**
//     * 售前负责人
//     */
////    private Long preSaleUserId;
//
//    /**
//     * 项目难度
//     */
////    private String projectDifficult;
//
//    /**
//     * 项目重要度
//     */
////    private String projectImportance;
//
//    /**
//     * 交付BU_ID
//     */
////    private Long deliOrgId;
//
//    /**
//     * 交付负责人ID
//     */
////    private Long deliUserId;
//
//    /**
//     * 方案难度
//     */
////    private String solutionDifficulty;
//    /**
//     * 方案难度
//     */
//    @ExcelProperty(index = 37, value = "方案难度")
//    private String solutionDifficultyName;
//    /**
//     * 方案重要度
//     */
////    private String solutionImportance;
//    /**
//     * 方案重要度
//     */
//    @ExcelProperty(index = 38, value = "方案重要度")
//    private String solutionImportanceName;
//    /**
//     * 合作(副)签单BU_ID
//     */
////    private Long coOrgId;
//    /**
//     * 合作(副)签单BU
//     */
//    @ExcelProperty(index = 39, value = "合作(副)签单BU")
//    private String coOrgName;
//    /**
//     * 合作(副)签单负责人ID
//     */
////    private Long coUserId;
//    /**
//     * 合作(副)签单负责人ID
//     */
//    @ExcelProperty(index = 40, value = "合作(副)签单负责人")
//    private String coUserName;
//    /**
//     * 合作(副)交付BU_ID
//     */
////    private Long codeliOrgId;
//    /**
//     * 合作(副)交付BU
//     */
//    @ExcelProperty(index = 41, value = "合作(副)交付BU")
//    private String codeliOrgName;
//    /**
//     * 合作(副)交付负责人ID
//     */
////    private Long codeliUserId;
//    /**
//     * 合作(副)交付负责人
//     */
//    @ExcelProperty(index = 42, value = "合作(副)交付负责人")
//    private String codeliUserName;
//    /**
//     * 来源类型
//     */
//    @ExcelProperty(index = 43, value = "合来源类型")
//    private String sourceType;
//    /**
//     * 内部来源BU_ID
//     */
////    private Long internalOrgId;
//    /**
//     * 内部来源BU
//     */
//    @ExcelProperty(index = 44, value = "内部来源BU")
//    private String internalOrgName;
//    /**
//     * 内部来源人ID
//     */
////    private Long internalUserId;
//    /**
//     * 内部来源人ID
//     */
//    @ExcelProperty(index = 45, value = "内部来源人")
//    private String internalUserName;
//    /**
//     * 外部线索来源
//     */
//    @ExcelProperty(index = 46, value = "外部线索来源")
//    private String externalIden;
//    /**
//     * 外部来源人
//     */
//    @ExcelProperty(index = 47, value = "外部来源人")
//    private String externalName;
//    /**
//     * 外部来源电话
//     */
//    @ExcelProperty(index = 48, value = "外部来源电话")
//    private String externalPhone;
//    /**
//     * 利益承诺
//     */
//    @ExcelProperty(index = 49, value = "利益承诺")
//    private String profitDesc;
//
//    @ExcelProperty(index = 50, value = "团队成员")
//    private String members;
//    /**
//     * 团队成员
//     */
////    private List<PrjProjectMemberVO> memberVOS;
//
//    /**
//     * 关联正式客户id
//     */
////    private Long formalCustomerId;
//
////    private String IsShow1;
////    private String IsShow2;
////    private String IsShow3;
//
//    @ExcelProperty(index = 51, value = "扩展字段1")
//    private String extString1;
//    @ExcelProperty(index = 52, value = "扩展字段2")
//    private String extString2;
//    @ExcelProperty(index = 53, value = "扩展字段3")
//    private String extString3;
//    @ExcelProperty(index = 54, value = "扩展字段4")
//    private String extString4;
//    @ExcelProperty(index = 55, value = "扩展字段5")
//    private String extString5;

//    private Long oppoIdV4;

}
