package com.elitesland.tw.tw5.api.prd.crm.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;

/**
 * 人脉-工作经历
 *
 * @author carl
 * @date 2022/12/07
 */
@Data
public class CrmPeopleWorkPayload extends TwCommonPayload {
    /**
     * 人脉主键
     */
    private Long peopleId;
    /**
     * 客户表主键
     */
    private Long customerId;

    /**
     * 输入的公司名称
     */
    private String companyName;

    /**
     * 类型
     */
    private String custType;

    /**
     * 职位
     */
    private String jobs;
    /**
     * 状态
     */
    private String workStatus;
    /**
     * 开始
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate startDate;
    /**
     * 结束
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate endDate;
    /**
     * 是否是初始化
     */
    private Boolean isInitia;
}
