package com.elitesland.tw.tw5.api.prd.humanresources.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdBuChangeTodoPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdBuChangeTodoQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdBuChangeTodoVO;


import java.util.List;


/**
 * @author : WWW
 * @date : 2023-11-7
 * @desc : baseBU变更待办事项Service
 */

public interface PrdBuChangeTodoService {

    /**
     * 新增baseBU变更待办事项数据
     *
     * @param prdBuChangeTodoPayload
     * @return
     */
    Boolean save(PrdBuChangeTodoPayload prdBuChangeTodoPayload);

    /**
     * 根据主键更新
     * @param prdBuChangeTodoPayload
     * @return
     */
//    PrdBuChangeTodoVO update(PrdBuChangeTodoPayload prdBuChangeTodoPayload);

    /**
     * 根据主键获取详情
     *
     * @param id
     * @return
     */
    PrdBuChangeTodoVO get(Long id);

    /**
     * 分页查询列表
     *
     * @param prdBuChangeTodoQuery
     * @return
     */
    PagingVO<PrdBuChangeTodoVO> page(PrdBuChangeTodoQuery prdBuChangeTodoQuery);

    /**
     * 根据主键批量删除
     *
     * @param ids
     * @return
     */
    Long del(List<Long> ids);

    /**
     * 获取列表查询
     *
     * @param prdBuChangeTodoQuery
     * @return
     */
    List<PrdBuChangeTodoVO> getList(PrdBuChangeTodoQuery prdBuChangeTodoQuery, Long userId);

    /**
     * 根据条件修改
     *
     * @param prdBuChangeTodoPayload
     * @return
     */
    Long updateByCondition(PrdBuChangeTodoPayload prdBuChangeTodoPayload);

    /**
     * 批量修改
     *
     * @param prdBuChangeTodoPayloadList
     * @return
     */
    Boolean updateByBatch(List<PrdBuChangeTodoPayload> prdBuChangeTodoPayloadList);
}

