package com.elitesland.tw.tw5.api.prd.humanresources.service;

import java.util.List;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEmployeCompositeAbilityPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEmployeCompositeAbilityQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEmployeCompositeAbilityVO;


/**
 * @author : WWW
 * @date : 2023-10-27
 * @desc : 员工-复合能力Service
 */
 
public interface PrdEmployeCompositeAbilityService {
    
    /**
     * 新增员工-复合能力数据
     * @param prdEmployeCompositeAbilityPayload
     * @return
     */
    PrdEmployeCompositeAbilityVO save(PrdEmployeCompositeAbilityPayload prdEmployeCompositeAbilityPayload);
    
     /**
     * 根据主键更新
     * @param prdEmployeCompositeAbilityPayload
     * @return
     */
    PrdEmployeCompositeAbilityVO update(PrdEmployeCompositeAbilityPayload prdEmployeCompositeAbilityPayload);
    
    /**
     * 根据主键获取详情
     * @param id
     * @return
     */
    PrdEmployeCompositeAbilityVO get(Long id);
    
     /**
     * 分页查询列表
     * @param prdEmployeCompositeAbilityQuery
     * @return
     */
    PagingVO<PrdEmployeCompositeAbilityVO> page(PrdEmployeCompositeAbilityQuery prdEmployeCompositeAbilityQuery);
    
     /**
     * 根据主键批量删除
     * @param ids
     * @return
     */
    Long del(List<Long> ids);
    
    /**
      * 获取列表查询
      * @param prdEmployeCompositeAbilityQuery
      * @return
      */
     List<PrdEmployeCompositeAbilityVO> getList(PrdEmployeCompositeAbilityQuery prdEmployeCompositeAbilityQuery);

     /**
      * 批量新增
      * @param prdEmployeCompositeAbilityPayload
      * @return
      */
     Boolean batchSave(List<PrdEmployeCompositeAbilityPayload> prdEmployeCompositeAbilityPayload);

     /**
      * 修改能力
      * @param prdEmployeCompositeAbilityPayload
      * @return
      */
     Long updateAbility(PrdEmployeCompositeAbilityPayload prdEmployeCompositeAbilityPayload);

    /**
     * 根据FormId、userid 修改状态信息
     * @param prdEmployeCompositeAbilityPayload
     * @return
     */
    Boolean updateStateByFormId(PrdEmployeCompositeAbilityPayload prdEmployeCompositeAbilityPayload);
}

