package com.elitesland.tw.tw5.api.prd.humanresources.service;

import java.util.List;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamRangePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamRangeQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamRangeVO;

import javax.servlet.http.HttpServletResponse;


 /**
 * @author : WWW
 * @date : 2023-11-14
 * @desc : 绩效考核范围Service
 */
 
public interface PrdPerformanceExamRangeService {
    
    /**
     * 新增绩效考核范围数据
     * @param prdPerformanceExamRangePayload
     * @return
     */
    PrdPerformanceExamRangeVO save(PrdPerformanceExamRangePayload prdPerformanceExamRangePayload);
    
     /**
     * 根据主键更新
     * @param prdPerformanceExamRangePayload
     * @return
     */
    PrdPerformanceExamRangeVO update(PrdPerformanceExamRangePayload prdPerformanceExamRangePayload);
    
    /**
     * 根据主键获取详情
     * @param id
     * @return
     */
    PrdPerformanceExamRangeVO get(Long id);
    
     /**
     * 分页查询列表
     * @param prdPerformanceExamRangeQuery
     * @return
     */
    PagingVO<PrdPerformanceExamRangeVO> page(PrdPerformanceExamRangeQuery prdPerformanceExamRangeQuery);
    
     /**
     * 根据主键批量删除
     * @param ids
     * @return
     */
    Long del(List<Long> ids);
    
    /**
      * 获取列表查询
      * @param prdPerformanceExamRangeQuery
      * @return
      */
     List<PrdPerformanceExamRangeVO> getList(PrdPerformanceExamRangeQuery prdPerformanceExamRangeQuery);
    
        /**
      * 根据条件修改
      * @param prdPerformanceExamRangePayload
      * @return
      */
     Long updateByCondition(PrdPerformanceExamRangePayload prdPerformanceExamRangePayload);

     /**
      * 批量新增
      * @param prdPerformanceExamRangePayload
      * @return
      */
     Boolean batchSave(List<PrdPerformanceExamRangePayload> prdPerformanceExamRangePayload);

     /**
      * 根据绩效id删除
      * @param id
      * @return
      */
     Long delByExamId(Long id);
 }

