package com.elitesland.tw.tw5.api.prd.humanresources.service;

import java.util.List;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdProbationExamPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdProbationExamQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdProbationExamVO;

import javax.servlet.http.HttpServletResponse;


/**
 * @author : WWW
 * @date : 2023-12-2
 * @desc : 试用期考核Service
 */

public interface PrdProbationExamService {

    /**
     * 新增试用期考核数据
     *
     * @param prdProbationExamPayload
     * @return
     */
    PrdProbationExamVO save(PrdProbationExamPayload prdProbationExamPayload);

    /**
     * 根据主键更新
     *
     * @param prdProbationExamPayload
     * @return
     */
    PrdProbationExamVO update(PrdProbationExamPayload prdProbationExamPayload);

    /**
     * 根据主键获取详情
     *
     * @param id
     * @return
     */
    PrdProbationExamVO get(Long id);

    /**
     * 分页查询列表
     *
     * @param prdProbationExamQuery
     * @return
     */
    PagingVO<PrdProbationExamVO> page(PrdProbationExamQuery prdProbationExamQuery);

    /**
     * 根据主键批量删除
     *
     * @param ids
     * @return
     */
    Long del(List<Long> ids);

    /**
     * 获取列表查询
     *
     * @param prdProbationExamQuery
     * @return
     */
    List<PrdProbationExamVO> getList(PrdProbationExamQuery prdProbationExamQuery);

    /**
     * 根据条件修改
     *
     * @param prdProbationExamPayload
     * @return
     */
    Long updateByCondition(PrdProbationExamPayload prdProbationExamPayload);

    /**
     * 试用期考核-定时任务(中期)
     *
     * @param param
     */
    void taskPrdProbationExamMid(String param);

    /**
     * 试用期考核-定时任务(末期)
     *
     * @param param
     */
    void taskPrdProbationExamLate(String param);
}

