package com.elitesland.tw.tw5.api.prd.inv.service;

import com.elitesland.tw.tw5.api.prd.inv.payload.InvItemPayload;
import com.elitesland.tw.tw5.api.prd.inv.query.InvItemQuery;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvItemVO;
import com.elitescloud.cloudt.common.base.PagingVO;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 发票商品对象（百望）
 *
 * @author zoey
 * @date 2023-07-31
 */
public interface InvItemService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link InvItemVO}>
     */
    PagingVO<InvItemVO> queryPaging(InvItemQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link InvItemVO}>
     */
    List<InvItemVO> queryListDynamic(InvItemQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link InvItemVO}
     */
    InvItemVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link InvItemVO}
     */
    InvItemVO insert(InvItemPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link InvItemVO}
     */
    InvItemVO update(InvItemPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(InvItemPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 从百望获取最新的商品信息
     * @return
     */
    int getInvoiceItemFromBaiwang();
}
