package com.elitesland.tw.tw5.api.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.AbnormalWorkApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.AbnormalWorkApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.AbnormalWorkApplyVO;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;

import java.util.List;

/**
 * 远程办公申请
 *
 * @author carl
 * @date 2024-04-19
 */
public interface AbnormalWorkApplyService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link AbnormalWorkApplyVO}>
     */
    PagingVO<AbnormalWorkApplyVO> queryPaging(AbnormalWorkApplyQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link AbnormalWorkApplyVO}>
     */
    List<AbnormalWorkApplyVO> queryListDynamic(AbnormalWorkApplyQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link AbnormalWorkApplyVO}
     */
    AbnormalWorkApplyVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link AbnormalWorkApplyVO}
     */
    AbnormalWorkApplyVO insertOrUpdate(AbnormalWorkApplyPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link AbnormalWorkApplyVO}
     */
    AbnormalWorkApplyVO update(AbnormalWorkApplyPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(AbnormalWorkApplyPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    void processStatusChange(ProcessStatusChangePayload payload);
}
