package com.elitesland.tw.tw5.api.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.OutWorkApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.OutWorkApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.OutWorkApplyVO;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;

import java.util.List;

/**
 * 外勤办公申请
 *
 * @author carl
 * @date 2024-05-22
 */
public interface OutWorkApplyService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link OutWorkApplyVO}>
     */
    PagingVO<OutWorkApplyVO> queryPaging(OutWorkApplyQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link OutWorkApplyVO}>
     */
    List<OutWorkApplyVO> queryListDynamic(OutWorkApplyQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link OutWorkApplyVO}
     */
    OutWorkApplyVO queryByKey(Long key);

    /**
     * 新增或修改
     *
     * @param payload 单据数据
     * @return {@link OutWorkApplyVO}
     */
    OutWorkApplyVO insertOrUpdate(OutWorkApplyPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link OutWorkApplyVO}
     */
    OutWorkApplyVO update(OutWorkApplyPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(OutWorkApplyPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 流程回调
     *
     * @param payload
     */
    void processStatusChange(ProcessStatusChangePayload payload);
}
