package com.elitesland.tw.tw5.api.prd.my.vo;

import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * APP端消息类别列表
 * @author likunpeng
 * @date 2023/6/12
 */
@Data
public class PrdUserMessageTypeVO {
    /**
     * 消息类别
     */
    @ApiModelProperty("消息类型")
    private String contentType;
    /**
     * 消息类别名称
     */
    @ApiModelProperty("消息类型名称")
    @UdcName(udcName = "sys:message_notice:type", codePropName = "contentType")
    private String contentTypeName;
    /**
     * 未读消息数量
     */
    @ApiModelProperty("未读消息数量")
    private Long unreadContentCount = 0L;
    /**
     * 最新一条消息
     */
    @ApiModelProperty("最新一条消息")
    private PrdUserMessageVO lastUserMessageVO;

}
