package com.elitesland.tw.tw5.api.prd.my.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 任务包授权主表
 *
 * @author duwh
 * @date 2022-12-16
 */
@Data
public class TaskAuthorizedVO extends BaseViewModel {
    /**
     * 名称
     */
    private String name;
    /**
     * 编号
     */
    private String authorizedNo;
    /**
     * 派发资源resid
     */
    private Long disterResId;
    /**
     * 派发资源userId v5
     */
    private Long disterUserId;
    /**
     * 接收资源resid
     */
    private Long receiverResId;
    /**
     * 接收资源userId v5
     */
    private Long receiverUserId;
    /**
     * 接收资源buid
     */
    private Long receiverBuId;
    /**
     * 接收资源组织id v5
     */
    private Long receiverOrgId;
    /**
     * 资源来源类型(合作类型)
     */
    private String resSourceType;
    /**
     * 验收方式
     */
    private String acceptMethod;
    /**
     * 计价方式
     */
    private String pricingMethod;
    /**
     * 事由类型
     */
    private String reasonType;
    /**
     * 事由号
     */
    private Long reasonId;
    /**
     * 事由号5.0主键
     */
    private Long reasonIdV5;
    /**
     * 费用承担bu
     */
    private Long expenseBuId;
    /**
     * 费用承担组织id v5
     */
    private Long expenseOrgId;
    /**
     * 授权总当量
     */
    private BigDecimal authEqva;
    /**
     * 已发当量
     */
    private BigDecimal useEqva;
    /**
     * 已发任务包数
     */
    private Integer useCount;
    /**
     * 工时、结算审批人是项目经理[pm]or授权资源[pl]
     */
    private String approvedType;
    /**
     * 计划开始时间
     */
    private LocalDate planStartDate;
    /**
     * 计划结束时间
     */
    private LocalDate planEndDate;
    /**
     * 完工附件上传方法
     */
    private String attachuploadMethod;
    /**
     * 审批状态
     */
    private String apprStatus;
    /**
     * 申请状态
     */
    private String applyStatus;
    /**
     * 是否授权接收人操作资源规划标志 0:不可操作,1:可操作
     */
    private Boolean authResPlanFlag;
}
