package com.elitesland.tw.tw5.api.prd.partner.common.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 业务伙伴-地址信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Getter
@Setter
public class BookAddressPayload extends TwCommonPayload  implements Serializable {

    /** 业务伙伴主键 business_partner.id */
    @ApiModelProperty("业务伙伴主键 business_partner.id")
    private Long partnerId;
    /** 地址薄id */
    @ApiModelProperty("地址薄id")
    private Long bookId;
    /** 地址类型 */
    @ApiModelProperty("地址类型")
    private String addressType;
    /** 国家 */
    @ApiModelProperty("国家")
    private String country;
    /** 省 */
    @ApiModelProperty("省")
    private String province;
    /** 市 */
    @ApiModelProperty("市")
    private String city;
    /** 区 */
    @ApiModelProperty("区")
    private String district;
    /** 详细地址 */
    @ApiModelProperty("详细地址")
    private String detailAddress;
    /** 电话 */
    @ApiModelProperty("电话")
    private String phone;
    /** 邮箱 */
    @ApiModelProperty("邮箱")
    private String email;
    /** 传真 */
    @ApiModelProperty("传真")
    private String fax;
    /** 联系人名称 */
    @ApiModelProperty("联系人名称")
    private String contractName;
    /** 省 */
    @ApiModelProperty("省")
    private String provinceName;
    /** 市 */
    @ApiModelProperty("市")
    private String cityName;
    /** 区 */
    @ApiModelProperty("区")
    private String districtName;
    /** 是否为默认地址信息 */
    @ApiModelProperty("是否为默认地址信息")
    private Boolean isDefault;
    /** 经度和纬度用,分割，经度在前，纬度在后，经纬度小数点后不得超过6位。多个坐标对之间用”|”进行分隔最多支持40对坐标 */
    @ApiModelProperty("经度和纬度用,分割，经度在前，纬度在后，经纬度小数点后不得超过6位。多个坐标对之间用”|”进行分隔最多支持40对坐标")
    private String longitudeLatitude;

    /** 是否需要操作记录 */
    @ApiModelProperty("是否需要操作记录")
    private Boolean logFlag;
}
