package com.elitesland.tw.tw5.api.prd.partner.strategy.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessStrategyIndexSettingPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessStrategyIndexSettingQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyIndexModelRefVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyIndexSettingVO;

import java.util.List;

/**
 * 分级策略指标配置
 *
 * @author wangly
 * @date 2023-06-19
 */
public interface BusinessStrategyIndexSettingService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BusinessStrategyIndexSettingVO}>
     */
    PagingVO<BusinessStrategyIndexSettingVO> queryPaging(BusinessStrategyIndexSettingQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BusinessStrategyIndexSettingVO}>
     */
    List<BusinessStrategyIndexSettingVO> queryListDynamic(BusinessStrategyIndexSettingQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BusinessStrategyIndexSettingVO}
     */
    BusinessStrategyIndexSettingVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BusinessStrategyIndexSettingVO}
     */
    BusinessStrategyIndexSettingVO insert(BusinessStrategyIndexSettingPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BusinessStrategyIndexSettingVO}
     */
    BusinessStrategyIndexSettingVO update(BusinessStrategyIndexSettingPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(BusinessStrategyIndexSettingPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 批量新增
     *
     * @param payloadList 单据数据集合
     * @param strategyId 分级策略id business_strategy.id
     */
    void saveAll(List<BusinessStrategyIndexSettingPayload> payloadList, Long strategyId);

    /**
     * 通过分级策略id(strategyId)查询
     *
     * @param strategyId business_strategy.id 分级策略id
     * @return {@link List<BusinessStrategyRefVO>}
     */
    List<BusinessStrategyIndexSettingVO> queryListByStrategyId(Long strategyId);

    /**
     * 通过分级策略id(strategyId)删除
     *
     * @param strategyId business_strategy.id 分级策略id
     */
    void deleteByStrategyId(Long strategyId);

    /**
     * 通过分级策略id(strategyId)查询指标和模型
     *
     * @param strategyId business_strategy.id 分级策略id
     */
    List<BusinessStrategyIndexModelRefVO> queryIndexModelRef(Long strategyId);

    /**
     * 通过分级策略id(strategyId)查询已经被删除的模型数量
     *
     * @param strategyIdList business_strategy.id 分级策略id
     */
    Long quertDeleteModelCountByStrategyIds(List<Long> strategyIdList);
}
