package com.elitesland.tw.tw5.api.prd.pay.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pay.payload.BkPayDetailRecordPayload;
import com.elitesland.tw.tw5.api.prd.pay.query.BkPayDetailRecordQuery;
import com.elitesland.tw.tw5.api.prd.pay.vo.BkPayDetailRecordVO;

import java.util.List;

/**
 * 支付管理-付款发送记录
 *
 * @author wangly
 * @date 2023-12-12
 */
public interface BkPayDetailRecordService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BkPayDetailRecordVO}>
     */
    PagingVO<BkPayDetailRecordVO> queryPaging(BkPayDetailRecordQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BkPayDetailRecordVO}>
     */
    List<BkPayDetailRecordVO> queryListDynamic(BkPayDetailRecordQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BkPayDetailRecordVO}
     */
    BkPayDetailRecordVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BkPayDetailRecordVO}
     */
    BkPayDetailRecordVO insert(BkPayDetailRecordPayload payload);

    /**
     * 批量插入
     *
     * @param payloads
     */
    void batchInsert(List<BkPayDetailRecordPayload> payloads);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BkPayDetailRecordVO}
     */
    BkPayDetailRecordVO update(BkPayDetailRecordPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(BkPayDetailRecordPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
