package com.elitesland.tw.tw5.api.prd.personplan.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.dialect.Ingres9Dialect;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;


/**
 * @author : WWW
 * @date : 2024-2-21
 * @desc : 人员规划
 */
@Data
@ApiModel(description = "人员规划")
public class PersonPlanVO extends BaseViewModel implements Serializable {

    /**
     * 关联对象id
     */
    @ApiModelProperty("关联对象id")
    private Long objId;

    /**
     * 关联对象
     */
    @ApiModelProperty("关联对象")
    private String objName;

    /**
     * 计划类型
     */
    @ApiModelProperty("计划类型 [PMS:RESOURCE_PLAN:PLAN_TYPE]")
    private String planType;

    /**
     * 计划类型
     */
    @ApiModelProperty("计划类型 [PMS:RESOURCE_PLAN:PLAN_TYPE]")
    @UdcName(udcName = "PMS:RESOURCE_PLAN:PLAN_TYPE",codePropName ="planType" )
    private String planTypeDesc;

    /**
     * 附件
     */
    @ApiModelProperty("附件")
    private String fileCodes;

    /**
     * 附件
     */
    @ApiModelProperty("附件")
    private Object fileDatas;
    /**
     * 状态
     */
    @ApiModelProperty("状态")
    private Integer state;

    /**
     * 开始日期
     */
    @ApiModelProperty("开始日期")
    private LocalDate startDate;

    /**
     * 结束日期
     */
    @ApiModelProperty("结束日期")
    private LocalDate endDate;

    /**
     * 持续时长
     */
    @ApiModelProperty("持续时长")
    private Integer duration;

    /**
     * 周期单位
     */
    @ApiModelProperty("周期单位")
    private String uom;

    /**
     * 当前版本
     */
    @ApiModelProperty("当前版本")
    private String version;

    /**
     * 项目ID
     */
    @ApiModelProperty("项目ID")
    private Long proId;

    /**
     * 人员规划明细集合
     */
    @ApiModelProperty("人员规划明细集合")
    private List<PersonPlanDtlVO> personPlanDtlVOList;

}

