package com.elitesland.tw.tw5.api.prd.personplan.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;


/**
 * @author : WWW
 * @date : 2024-1-29
 * @desc : 项目相关方
 */
@Data
@ApiModel(description = "项目相关方")
public class ProRelatedPartiesVO extends BaseViewModel implements Serializable {


    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Long proId;

    /**
     * 用户id
     */
    @ApiModelProperty("用户id")
    private Long userId;
    private String userName;

    /**
     * 外部相关方id
     */
    @ApiModelProperty("外部相关方id")
    private Long externalId;

    /**
     * 相关方名称
     */
    @ApiModelProperty("相关方名称")
    private String name;

    /**
     * 相关方类型
     */
    @ApiModelProperty("相关方类型")
    private String relatedType;

    /**
     * 项目角色
     */
    @ApiModelProperty("项目角色")
    private String proRole;


    /**
     * 项目角色名称
     */
    @ApiModelProperty("项目角色名称")
    private String proRoleName;

    /**
     * 联系电话
     */
    @ApiModelProperty("联系电话")
    private String phone;

    /**
     * 邮箱
     */
    @ApiModelProperty("邮箱")
    private String email;

    /**
     * 公司id
     */
    @ApiModelProperty("公司id")
    private Long ouId;

    /**
     * 公司编码
     */
    @ApiModelProperty("公司编码")
    private String ouCode;

    /**
     * 公司名称
     */
    @ApiModelProperty("公司名称")
    private String ouName;

    /**
     * 利益相关程度
     */
    @ApiModelProperty("利益相关程度")
    private Integer ext1;

    /**
     * 权利程度
     */
    @ApiModelProperty("权利程度")
    private Integer ext2;

    /**
     * 情感倾向
     */
    @ApiModelProperty("情感倾向")
    private Integer ext3;

    /**
     * 参与度
     */
    @ApiModelProperty("参与度")
    private BigDecimal ext4;

    /**
     * 类型0内部相关方 1外部相关方
     */
    @ApiModelProperty("类型0内部相关方 1外部相关方")
    private Integer type;

    /**
     * 所属部门
     */
    @ApiModelProperty("所属部门")
    private String buName;


    /**
     * 当量
     */
    @ApiModelProperty("当量")
    private BigDecimal eqvaRatio;


    /**
     * 参考当量(通过资源成本配置实时获取)
     */
    @ApiModelProperty("参考当量")
    private BigDecimal referenceEqvaRatio;


    @ApiModelProperty("项目角色List")
    private List<PmsProjectRoleVO> projectRoleVOList;


    /**
     * 项目名称
     */
    @ApiModelProperty("项目名称")
    private String proName;

    /**
     * 项目类型
     */
    @ApiModelProperty("项目类型")
    private String proExt1;
    private String proExt1Desc;


    /**
     * 预计开始日期
     */
    @ApiModelProperty("预计开始日期")
    private LocalDateTime planStartDate;
    /**
     * 预计结束日期
     */
    @ApiModelProperty("预计结束日期")
    private LocalDate planEndDate;

    /**
     * 预计结束日期
     */
    @ApiModelProperty("预计结束日期")
    private LocalDateTime createTime;

    /**
     * 引入资源相关项目
     */
    @ApiModelProperty("引入资源相关项目")
    private List<PersonPlanDtlAndProjectVO> personPlanDtlAndProjectVOList;
}

