package com.elitesland.tw.tw5.api.prd.pms.budget.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.budget.payload.PmsWbsBudgetReleasePayload;
import com.elitesland.tw.tw5.api.prd.pms.budget.query.PmsWbsBudgetReleaseQuery;
import com.elitesland.tw.tw5.api.prd.pms.budget.vo.PmsWbsBudgetReleaseVO;


import java.util.List;


/**
 * 预算释放表service
 * @author duwh
 * @date 2024/3/7
*/
public interface PmsWbsBudgetReleaseService {

    /**
     * 分页查询
     *
     * @param query query
     * @return result
     */
    PagingVO<PmsWbsBudgetReleaseVO> queryPage(PmsWbsBudgetReleaseQuery query);

    /**
     * 列表查询
     *
     * @param query query
     * @return result
     */
    List<PmsWbsBudgetReleaseVO> queryList(PmsWbsBudgetReleaseQuery query);

    /**
     * count查询
     *
     * @param query query
     * @return result
     */
    long queryCount(PmsWbsBudgetReleaseQuery query);

    /**
     * 根据主键获取详情
     *
     * @param id 主键
     * @return result
     */
    PmsWbsBudgetReleaseVO queryByKey(Long id);

    /**
     * 新增
     *
     * @param payload payload
     * @return result
     */
    PmsWbsBudgetReleaseVO insert(PmsWbsBudgetReleasePayload payload);

    /**
     * 修改
     *
     * @param payload payload
     * @return result
     */
    PmsWbsBudgetReleaseVO update(PmsWbsBudgetReleasePayload payload);

    /**
     * 动态修改，一般只用在少部分字段修改的场景，比如修改状态
     *
     * @param payload payload
     * @return result
     */
    PmsWbsBudgetReleaseVO updateDynamic(PmsWbsBudgetReleasePayload payload);

    /**
     * 逻辑删除
     *
     * @param ids ids
     * @return result
     */
    Long deleteSoft(List<Long> ids);

    List<PmsWbsBudgetReleaseVO> insertAll(List<PmsWbsBudgetReleasePayload> releasePayloadList);

    PmsWbsBudgetReleaseVO updatePro(PmsWbsBudgetReleasePayload payload);
}
