package com.elitesland.tw.tw5.api.prd.pms.budget.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.budget.payload.PmsWbsBudgetPayload;
import com.elitesland.tw.tw5.api.prd.pms.budget.query.PmsWbsBudgetQuery;
import com.elitesland.tw.tw5.api.prd.pms.budget.vo.PmsWbsBudgetVO;


import java.math.BigDecimal;
import java.util.List;


/**
 * 预算主表service
 *
 * @author duwh
 * @date 2024/3/7
 */
public interface PmsWbsBudgetService {

    /**
     * 分页查询
     *
     * @param query query
     * @return result
     */
    PagingVO<PmsWbsBudgetVO> queryPage(PmsWbsBudgetQuery query);

    /**
     * 列表查询
     *
     * @param query query
     * @return result
     */
    List<PmsWbsBudgetVO> queryList(PmsWbsBudgetQuery query);

    /**
     * count查询
     *
     * @param query query
     * @return result
     */
    long queryCount(PmsWbsBudgetQuery query);

    /**
     * 根据主键获取详情
     *
     * @param id 主键
     * @return result
     */
    PmsWbsBudgetVO queryByKey(Long id);

    /**
     * 新增
     *
     * @param payload payload
     * @return result
     */
    PmsWbsBudgetVO insert(PmsWbsBudgetPayload payload);

    /**
     * 修改
     *
     * @param payload payload
     * @return result
     */
    PmsWbsBudgetVO update(PmsWbsBudgetPayload payload);

    /**
     * 动态修改，一般只用在少部分字段修改的场景，比如修改状态
     *
     * @param payload payload
     * @return result
     */
    PmsWbsBudgetVO updateDynamic(PmsWbsBudgetPayload payload);

    /**
     * 逻辑删除
     *
     * @param ids ids
     * @return result
     */
    Long deleteSoft(List<Long> ids);

    List<PmsWbsBudgetVO> insertAll(List<PmsWbsBudgetPayload> newBudgetList);

    /**
     * 按项目 id和版本id获取
     *
     * @param proId     项目 id
     * @param versionId 版本id
     * @return {@link PmsWbsBudgetVO}
     */
    PmsWbsBudgetVO getByProIdAndVersionId(Long proId, Long versionId);

    /**
     * 应用人员规划-根据资源规划总额变更预算
     *
     * @param proId    亲id
     * @param budgetId 预算id
     * @return {@link PmsWbsBudgetVO}
     */
    BigDecimal updateByResPlan(Long proId, Long budgetId);
}
