package com.elitesland.tw.tw5.api.prd.pms.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 项目wbs表
 *
 * @author carl
 * @date 2023-04-06
 */
@Getter
@Setter
public class PmsProjectWbsDataPayload extends TwCommonPayload implements Serializable {
    /**
     * 项目主键
     */
    @ApiModelProperty("项目主键")
    private Long projectId;
    /**
     * wbs
     */
    @ApiModelProperty("wbs")
    private List<PmsProjectWbsPayload> wbsPayloads;
    /**
     * 删除的wbs ids
     */
    @ApiModelProperty("删除的wbs ids")
    private List<Long> delWbsIds;
    /**
     * 是否从模板创建
     */
    @ApiModelProperty("是否从模板创建")
    private Boolean isTempCreate = false;

    /**
     * 是否是导入
     */
    @ApiModelProperty("是否是导入")
    private Boolean isImportCreate = false;
}
