package com.elitesland.tw.tw5.api.prd.pms.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * 项目wbs排期表
 *
 * @author carl
 * @date 2023-07-21
 */
@Getter
@Setter
public class PmsProjectWbsSchedulingPayload extends TwCommonPayload implements Serializable {
    /**
     * 项目主键
     */
    @ApiModelProperty("项目主键")
    private Long projectId;
    /**
     * 起始日期
     */
    @ApiModelProperty("起始日期")
    private LocalDate startDate;

    /**
     * 排期方向（0正排，1倒排）
     */
    @ApiModelProperty("排期方向（0正排，1倒排）")
    private Integer schedulingDirection;


    /**
     * 日期排程（0尽早，1尽晚）
     */
    @ApiModelProperty("日期排程（0尽早，1尽晚）")
    private Integer schedulingMode;


    @ApiModelProperty("版本号")
    private Integer versionNo;


}
