package com.elitesland.tw.tw5.api.prd.pms.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 预算科目
 *
 * @author xxb
 * @date 2023-04-23
 */
@Getter
@Setter
public class PmsBudgetSubjectQuery extends TwQueryParam implements Serializable {
    /**
     * 科目编号 模糊
     */
    @ApiModelProperty("科目编号")
    @Query
    private String subjectCode;

    /**
     * 科目名称 模糊
     */
    @ApiModelProperty("科目名称")
    @Query
    private String subjectName;

    /**
     * 层级
     */
    @ApiModelProperty("层级")
    private Integer subjectLevel;

    @ApiModelProperty("科目id集合")
    private List<Long> subjectIds;

    /**
     * 科目状态
     */
    @ApiModelProperty("科目状态 0正常  1弃用")
    private Integer subjectStatus;

    /** 上一级科目即父主键 */
    @ApiModelProperty("上一级科目即父主键")
    private Long parentId;


}
