package com.elitesland.tw.tw5.api.prd.pms.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * 项目wbs表
 *
 * @author carl
 * @date 2023-04-06
 */
@Getter
@Setter
public class PmsProjectWbsQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    @Query
    private Long id;
    private List<Long> idList;
    /**
     * 项目主键 精确
     */
    @ApiModelProperty("项目主键")
    @Query
    private Long projectId;
    /**
     * 节点关键词
     */
    @ApiModelProperty("wbs描述（名称）")
    @Query(type = Query.Type.INNER_LIKE)
    private String wbsSearch;
    /**
     * wbs描述（名称） 模糊
     */
    @ApiModelProperty("wbs描述（名称）")
    @Query(type = Query.Type.INNER_LIKE)
    private String wbsName;
    /**
     * wbs类型(WBS,NET,ACT,MS) 精确
     */
    @ApiModelProperty("wbs类型(WBS,NET,ACT,MS)")
    @Query
    private String wbsType;
    /**
     * wbs编码 模糊
     */
    @ApiModelProperty("wbs编码")
    @Query(type = Query.Type.INNER_LIKE)
    private String wbsCode;
    /**
     * node码 精确
     */
    @ApiModelProperty("node码")
    @Query
    private String nodeCode;
    /**
     * 父节点（前端传值）
     */
    @ApiModelProperty("父节点")
    private String parentWbsCode;

    /**
     * 节点负责人
     */
    @ApiModelProperty("节点负责人")
    private Long managerUserId;

    /**
     * 成本对象，勾选为1 精确
     */
    @ApiModelProperty("成本对象，勾选为1")
    @Query
    private Integer subjectDist;

    /**
     * 类型 精确
     */
    @ApiModelProperty("成本类型")
    @Query
    private String costType;
    /**
     * 实际开始时间 精确
     */
    @ApiModelProperty("实际开始时间")
    private LocalDate startDate;
    /**
     * 实际结束时间 精确
     */
    @ApiModelProperty("实际结束时间")
    private LocalDate endDate;
    /**
     * 实际持续时间（天）
     */
    @ApiModelProperty("实际持续时间（天）")
    private BigDecimal durationDay;
    /**
     * 预计开始时间 大于等于
     */
    @ApiModelProperty("预计开始时间")
    private LocalDate preStartDate;
    /**
     * 预计结束时间 小于等于
     */
    @ApiModelProperty("预计结束时间")
    private LocalDate preEndDate;
    /**
     * 预计持续时间（天） 精确
     */
    @ApiModelProperty("预计持续时间（天）")
    private BigDecimal preDurationDay;
    /**
     * 进度(%) 精确
     */
    @ApiModelProperty("进度(%)")
    private BigDecimal wbsProgress;


    /**
     * 状态
     */
    @ApiModelProperty("wbs状态")
    private String wbsStatus;

    /**
     * 状态 活动清单查询升级版  未开始-查询未开始  已开始-查询已开始 + 已开始->已结束的数据cancelShowFlag=true
     */
    @ApiModelProperty("wbs状态")
    private String wbsStatusPro;


    /**
     * 开票属性，勾选为1 精确
     */
    @ApiModelProperty("开票属性，勾选为1")
    @Query
    private Integer invoiceAttr;
    /**
     * 成本计划，勾选为1 精确
     */
    @ApiModelProperty("成本计划，勾选为1")
    @Query
    private Integer costPlan;

    //负责人列表
    private List<Long> managerUserIds;

    // 父节点集合
    private List<String> parentWbsCodes;


    /**
     * 状态
     */
    @ApiModelProperty("状态")
    private String state;

    /**
     * 负责人（相关方）
     */
    private Long managerRelatePartiesId;
    /**
     * 负责人名称（相关方)
     */
    private String managerRelatePartiesName;

    /**
     * 版本id
     */
    @ApiModelProperty("版本id")
    private Long versionId;


    /**
     * 版本号
     */
    @ApiModelProperty("版本号")
    private Integer versionNo;

    @ApiModelProperty("预算释放标记 true 已释放  false 未释放（default）")
    private Boolean releaseFlag;

    /** 收款计划ID 精确 */
    @ApiModelProperty("收款计划ID")
    private Long receivePlanId;
}
