package com.elitesland.tw.tw5.api.prd.pms.query;


import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.time.LocalDate;


/**
 * 项目wbs模板表query
 * @author wangxl
 * @date 2024/4/2
 */
@Data
@ApiModel(description = "项目wbs模板表query")
public class PmsProjectWbsTempQuery extends TwQueryParam {

    /**
     * 项目主键
     */
    @ApiModelProperty("项目模板主键")
    private Long tempId;

    /**
     * 父主键
     */
    @ApiModelProperty("父主键")
    private Long parentId;

    /**
     * wbs描述（名称）
     */
    @ApiModelProperty("wbs描述（名称）")
    private String wbsName;

    /**
     * wbs类型(WBS,NET,ACT,MS)
     */
    @ApiModelProperty("wbs类型(WBS,NET,ACT,MS)")
    private String wbsType;

    /**
     * wbs编码
     */
    @ApiModelProperty("wbs编码")
    private String wbsCode;

    /**
     * 父节点
     */
    @ApiModelProperty("父节点")
    private String parentWbsCode;

    /**
     * node码
     */
    @ApiModelProperty("node码")
    private String nodeCode;

    /**
     * 节点负责人
     */
    @ApiModelProperty("节点负责人")
    private Long managerUserId;

    /**
     * 成本对象，勾选为1
     */
    @ApiModelProperty("成本对象，勾选为1")
    private Boolean subjectDist;

    /**
     * 成本类型
     */
    @ApiModelProperty("成本类型")
    private String costType;

    /**
     * 预计开始时间
     */
    @ApiModelProperty("预计开始时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate preStartDate;

    /**
     * 预计结束时间
     */
    @ApiModelProperty("预计结束时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate preEndDate;

    /**
     * 预计持续时间（天）
     */
    @ApiModelProperty("预计持续时间（天）")
    private BigDecimal preDurationDay;

    /**
     * 进度(%)
     */
    @ApiModelProperty("进度(%)")
    private BigDecimal wbsProgress;

    /**
     * 实际开始时间
     */
    @ApiModelProperty("实际开始时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate startDate;

    /**
     * 实际结束时间
     */
    @ApiModelProperty("实际结束时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate endDate;

    /**
     * 实际持续时间（天）
     */
    @ApiModelProperty("实际持续时间（天）")
    private BigDecimal durationDay;

    /**
     * 最早开始时间
     */
    @ApiModelProperty("最早开始时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate earlyStartDate;

    /**
     * 最早结束时间
     */
    @ApiModelProperty("最早结束时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate earlyEndDate;

    /**
     * 最晚开始时间
     */
    @ApiModelProperty("最晚开始时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate lateStartDate;

    /**
     * 最晚结束日期
     */
    @ApiModelProperty("最晚结束日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate lateEndDate;

    /**
     * 总浮时
     */
    @ApiModelProperty("总浮时")
    private BigDecimal totalFloat;

    /**
     * 自由浮时
     */
    @ApiModelProperty("自由浮时")
    private BigDecimal freeFloat;

    /**
     * 延时
     */
    @ApiModelProperty("延时")
    private BigDecimal delayLag;

    /**
     * 是否是关键节点0:否，1：是
     */
    @ApiModelProperty("是否是关键节点0:否，1：是")
    private Boolean isKeyNode;

    /**
     * 是否自动排期0：未进行，1：已排期，2：已过期
     */
    @ApiModelProperty("是否自动排期0：未进行，1：已排期，2：已过期")
    private Boolean autoScheduling;

    /**
     * 状态
     */
    @ApiModelProperty("状态")
    private String wbsStatus;

    /**
     * 已开始状态的数据 当取消的时候 显示标志改为 true
     */
    @ApiModelProperty("已开始状态的数据 当取消的时候 显示标志改为 true")
    private Boolean cancelShowFlag;

    /**
     * 成本计划，勾选为1
     */
    @ApiModelProperty("成本计划，勾选为1")
    private Boolean costPlan;

    /**
     * 开票属性，勾选为1
     */
    @ApiModelProperty("开票属性，勾选为1")
    private Boolean invoiceAttr;

    /**
     * wbs权重
     */
    @ApiModelProperty("wbs权重")
    private BigDecimal wbsWeight;

    /**
     * wbs权重设置方式：1为手动设置  0为系统设置
     */
    @ApiModelProperty("wbs权重设置方式：1为手动设置  0为系统设置")
    private Integer manualSettingWeight;

    /**
     * 状态 0草稿 1提交
     */
//    @ApiModelProperty("状态 0草稿 1提交")
//    private String state;

    /**
     * 版本
     */
    @ApiModelProperty("版本")
    private Long versionId;

    /**
     * 版本号
     */
    @ApiModelProperty("版本号")
    private Integer versionNo;

    /**
     * 有效关联id
     */
    @ApiModelProperty("有效关联id")
    private Long effRelateId;

    /**
     * 预算释放标记 true 已释放  false 未释放（default）
     */
    @ApiModelProperty("预算释放标记 true 已释放  false 未释放（default）")
    private Boolean releaseFlag;

    /**
     * 锁版本
     */
    @ApiModelProperty("锁版本")
    private Integer auditDataVersion;

    /**
     * 数据归属组织id
     */
    @ApiModelProperty("数据归属组织id")
    private Long secBuId;

    /**
     * 数据归属雇员id
     */
    @ApiModelProperty("数据归属雇员id")
    private Long secUserId;

    /**
     * 数据归属公司id
     */
    @ApiModelProperty("数据归属公司id")
    private Long secOuId;

    /**
     * 收款计划ID
     */
    @ApiModelProperty("收款计划ID")
    private Long receivePlanId;

    /**
     * 拨付状态
     */
    @ApiModelProperty("拨付状态")
    private String allocateStatus;

    /**
     * 当量系数
     */
    @ApiModelProperty("当量系数")
    private BigDecimal eqvaRate;

    /**
     * 规划当量
     */
    @ApiModelProperty("规划当量")
    private BigDecimal planEqva;

    /**
     * 原始规划当量
     */
    @ApiModelProperty("原始规划当量")
    private BigDecimal originalPlanEqva;

    /**
     * 已派发当量
     */
    @ApiModelProperty("已派发当量")
    private BigDecimal distedEqva;

    /**
     * 拨付当量
     */
    @ApiModelProperty("拨付当量")
    private BigDecimal allocateEqva;

    /**
     * 拨付费用
     */
    @ApiModelProperty("拨付费用")
    private BigDecimal allocateCost;

    /**
     * 明细控制
     */
    @ApiModelProperty("明细控制")
    private Boolean detailControlFlag;

    /**
     * 占用当量数
     */
    @ApiModelProperty("占用当量数")
    private BigDecimal occupyEqva;

    /**
     * 已使用当量数
     */
    @ApiModelProperty("已使用当量数")
    private BigDecimal usedEqva;

    /**
     * 使用当量占比
     */
    @ApiModelProperty("使用当量占比")
    private BigDecimal usedEqvaProportion;

    /**
     * 使用费用占比
     */
    @ApiModelProperty("使用费用占比")
    private BigDecimal usedAmtProportion;

}
