package com.elitesland.tw.tw5.api.prd.pms.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsBudgetDetailPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsBudgetPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsBudgetDetailQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsBudgetDetailVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsBudgetVO;
import com.elitesland.tw.tw5.api.prd.task.vo.PmsWbsTaskVO;


import java.util.List;

/**
 * 预算明细
 *
 * @author xxb
 * @date 2023-07-10
 */
public interface PmsBudgetDetailService {

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PmsBudgetDetailVO}
     */
    PmsBudgetDetailVO insert(PmsBudgetDetailPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PmsBudgetDetailVO}
     */
    PmsBudgetDetailVO update(PmsBudgetDetailPayload payload);


    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsBudgetDetailVO}>
     */
    PagingVO<PmsBudgetDetailVO> queryPaging(PmsBudgetDetailQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsBudgetDetailVO}>
     */
    List<PmsBudgetDetailVO> queryListDynamic(PmsBudgetDetailQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PmsBudgetDetailVO}
     */
    PmsBudgetDetailVO queryByKey(Long key);

    /**
     * 新增
     * @param payload
     * @return
     */
    void insert(PmsBudgetPayload payload);


    /**
     * 更改使用金额
     * @param wbsId
     */
    void updateUsedMoney(Long wbsId, List<PmsWbsTaskVO> list);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(Long budgetId,List<Long> keys);


    /**
     * 根据 wbs 查询相应 预算信息
     * @param wbsId
     * @return
     */
    PmsBudgetVO queryByWbs(Long projectId,Long wbsId);


    /**
     * 查询预算 状态
     * @param projectId
     * @return
     */
    String queryProjectBudgetStatus(Long projectId,Long wbsId);


    /**
     * 根据 wbs 查询相应 预算信息
     * @param wbsIds
     * @return
     */
    List<PmsBudgetVO> queryByWbsList(List<Long> wbsIds);

    /**
     * 根据 项目 查询相应 预算信息
     * @param projectId
     * @return
     */
    PmsBudgetVO queryByProject(Long projectId);

    /**
     * 提交预算审批
     * @param projectId
     * @return
     */
    void submitApprovalProcess(Long projectId);


    /**
     * 删除wbs活动下预算
     * @param keys
     */
    void deleteSoftByWbsIds(List<Long> keys);
}
