package com.elitesland.tw.tw5.api.prd.pms.service;

import java.util.List;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsResourcePayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsResourceQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsResourceVO;


import javax.servlet.http.HttpServletResponse;


/**
 * @author : WWW
 * @date : 2024-2-26
 * @desc : 项目wbs资源分配Service
 */
public interface PmsProjectWbsResourceService {

   /**
    * 新增项目wbs资源分配数据
    * @param pmsProjectWbsResourcePayload
    * @return
    */
   PmsProjectWbsResourceVO save(PmsProjectWbsResourcePayload pmsProjectWbsResourcePayload);

   /**
    * 根据主键更新
    * @param pmsProjectWbsResourcePayload
    * @return
    */
   PmsProjectWbsResourceVO updateAll(PmsProjectWbsResourcePayload pmsProjectWbsResourcePayload);

   /**
    * 根据主键获取详情
    * @param id
    * @return
    */
   PmsProjectWbsResourceVO get(Long id);

   /**
    * 分页查询列表
    * @param pmsProjectWbsResourceQuery
    * @return
    */
   PagingVO<PmsProjectWbsResourceVO> page(PmsProjectWbsResourceQuery pmsProjectWbsResourceQuery);

   /**
    * 根据主键批量删除
    * @param ids
    * @return
    */
   Long del(List<Long> ids);

   /**
    * 获取列表查询
    * @param pmsProjectWbsResourceQuery
    * @return
    */
   List<PmsProjectWbsResourceVO> getList(PmsProjectWbsResourceQuery pmsProjectWbsResourceQuery);

   /**
    * 根据条件修改
    * @param pmsProjectWbsResourcePayload
    * @return
    */
   Long update(PmsProjectWbsResourcePayload pmsProjectWbsResourcePayload);

    /**
     * 批量新增
     * @param pmsProjectWbsResourcePayload
     * @return
     */
    Boolean saveAll(List<PmsProjectWbsResourcePayload> pmsProjectWbsResourcePayload);
}

